/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.collections;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.ex.ElementWithTextNotFound;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.ElementCommunicator;
import com.codeborne.selenide.impl.Plugins;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ItemWithText
extends CollectionCondition {
    private static final ElementCommunicator communicator = Plugins.inject(ElementCommunicator.class);
    private final String expectedText;

    public ItemWithText(String expectedText) {
        this.expectedText = expectedText;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public CheckResult check(CollectionSource collection) {
        List<WebElement> elements = collection.getElements();
        List<String> texts = communicator.texts(collection.driver(), elements);
        return new CheckResult(texts.contains(this.expectedText), texts);
    }

    @Override
    public void fail(CollectionSource collection, CheckResult lastCheckResult, @Nullable Exception cause, long timeoutMs) {
        throw new ElementWithTextNotFound(collection, Collections.singletonList(this.expectedText), (List)lastCheckResult.getActualValue(), this.explanation, timeoutMs, cause);
    }

    @Override
    @CheckReturnValue
    public boolean missingElementSatisfiesCondition() {
        return false;
    }

    @CheckReturnValue
    public String toString() {
        return "Text " + this.expectedText;
    }
}

