/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class Stopwatch {
    private final long startTimeNano;
    private final long timeoutNano;

    public Stopwatch(long timeoutMs) {
        this(timeoutMs, System.nanoTime());
    }

    Stopwatch(long timeoutMs, long startTimeNano) {
        this.startTimeNano = startTimeNano;
        this.timeoutNano = TimeUnit.MILLISECONDS.toNanos(timeoutMs);
    }

    @CheckReturnValue
    public boolean isTimeoutReached() {
        return this.isTimeoutReached(System.nanoTime());
    }

    boolean isTimeoutReached(long now) {
        return now - this.startTimeNano > this.timeoutNano;
    }

    public void sleep(long milliseconds) {
        if (this.isTimeoutReached()) {
            return;
        }
        try {
            Thread.sleep(milliseconds);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public static void sleepAtLeast(long milliseconds) {
        Stopwatch stopwatch = new Stopwatch(milliseconds);
        do {
            stopwatch.sleep(milliseconds);
        } while (!stopwatch.isTimeoutReached());
    }
}

