/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.CollectionCondition;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.Stopwatch;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.impl.BySelectorCollection;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.CollectionElement;
import com.codeborne.selenide.impl.CollectionElementByCondition;
import com.codeborne.selenide.impl.CollectionSnapshot;
import com.codeborne.selenide.impl.CollectionSource;
import com.codeborne.selenide.impl.ElementCommunicator;
import com.codeborne.selenide.impl.FilteringCollection;
import com.codeborne.selenide.impl.HeadOfCollection;
import com.codeborne.selenide.impl.LastCollectionElement;
import com.codeborne.selenide.impl.Plugins;
import com.codeborne.selenide.impl.SelenideElementIterator;
import com.codeborne.selenide.impl.SelenideElementListIterator;
import com.codeborne.selenide.impl.TailOfCollection;
import com.codeborne.selenide.impl.WebElementsCollectionWrapper;
import com.codeborne.selenide.logevents.ErrorsCollector;
import com.codeborne.selenide.logevents.LogEvent;
import com.codeborne.selenide.logevents.SelenideLog;
import com.codeborne.selenide.logevents.SelenideLogger;
import java.time.Duration;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class ElementsCollection
extends AbstractList<SelenideElement> {
    private static final ElementCommunicator communicator = Plugins.inject(ElementCommunicator.class);
    private final CollectionSource collection;

    public ElementsCollection(CollectionSource collection) {
        this.collection = collection;
    }

    public ElementsCollection(Driver driver, Collection<? extends WebElement> elements) {
        this(new WebElementsCollectionWrapper(driver, elements));
    }

    public ElementsCollection(Driver driver, String cssSelector) {
        this(driver, By.cssSelector((String)cssSelector));
    }

    public ElementsCollection(Driver driver, By seleniumSelector) {
        this(new BySelectorCollection(driver, seleniumSelector));
    }

    @Nonnull
    public ElementsCollection should(CollectionCondition ... conditions) {
        return this.should("", Duration.ofMillis(this.driver().config().timeout()), conditions);
    }

    @Nonnull
    public ElementsCollection should(CollectionCondition condition, Duration timeout) {
        return this.should("", timeout, this.toArray(condition));
    }

    @Nonnull
    public ElementsCollection shouldBe(CollectionCondition ... conditions) {
        return this.should("be", Duration.ofMillis(this.driver().config().timeout()), conditions);
    }

    @Nonnull
    public ElementsCollection shouldBe(CollectionCondition condition, Duration timeout) {
        return this.should("be", timeout, this.toArray(condition));
    }

    @Nonnull
    public ElementsCollection shouldHave(CollectionCondition ... conditions) {
        return this.should("have", Duration.ofMillis(this.driver().config().timeout()), conditions);
    }

    @Nonnull
    public ElementsCollection shouldHave(CollectionCondition condition, Duration timeout) {
        return this.should("have", timeout, this.toArray(condition));
    }

    @CheckReturnValue
    @Nonnull
    private CollectionCondition[] toArray(CollectionCondition condition) {
        return new CollectionCondition[]{condition};
    }

    @Nonnull
    protected ElementsCollection should(String prefix, Duration timeout, CollectionCondition ... conditions) {
        ErrorsCollector.validateAssertionMode(this.driver().config());
        SelenideLog log = SelenideLogger.beginStep(this.collection.shortDescription(), "should " + prefix, conditions);
        try {
            for (CollectionCondition condition : conditions) {
                this.waitUntil(condition, timeout);
            }
            SelenideLogger.commitStep(log, LogEvent.EventStatus.PASS);
            return this;
        }
        catch (Error error) {
            Error wrappedError = UIAssertionError.wrap(this.driver(), error, timeout.toMillis());
            SelenideLogger.commitStep(log, wrappedError);
            switch (this.driver().config().assertionMode()) {
                case SOFT: {
                    return this;
                }
            }
            throw wrappedError;
        }
        catch (RuntimeException e) {
            SelenideLogger.commitStep(log, e);
            throw e;
        }
    }

    protected void waitUntil(CollectionCondition condition, Duration timeout) {
        Object lastError = null;
        CheckResult lastCheckResult = new CheckResult(CheckResult.Verdict.REJECT, null);
        Stopwatch stopwatch = new Stopwatch(timeout.toMillis());
        do {
            try {
                lastCheckResult = condition.check(this.collection);
                if (lastCheckResult.verdict() == CheckResult.Verdict.ACCEPT) {
                    return;
                }
            }
            catch (JavascriptException e) {
                throw e;
            }
            catch (UIAssertionError | IndexOutOfBoundsException | WebDriverException elementNotFound) {
                if (Cleanup.of.isInvalidSelectorError((Throwable)elementNotFound)) {
                    throw Cleanup.of.wrapInvalidSelectorException((Throwable)elementNotFound);
                }
                if (condition.missingElementSatisfiesCondition()) {
                    return;
                }
                lastError = elementNotFound;
            }
            this.sleep(this.driver().config().pollingInterval());
        } while (!stopwatch.isTimeoutReached());
        if (lastError instanceof IndexOutOfBoundsException) {
            throw new ElementNotFound(this.collection.driver(), this.collection.getAlias(), this.collection.description(), Condition.exist, (Throwable)lastError);
        }
        if (lastError instanceof UIAssertionError) {
            UIAssertionError uiAssertionError = (UIAssertionError)((Object)lastError);
            throw uiAssertionError;
        }
        condition.fail(this.collection, lastCheckResult, (Exception)lastError, timeout.toMillis());
    }

    void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection filter(Condition condition) {
        return new ElementsCollection(new FilteringCollection(this.collection, condition));
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection filterBy(Condition condition) {
        return this.filter(condition);
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection exclude(Condition condition) {
        return new ElementsCollection(new FilteringCollection(this.collection, Condition.not(condition)));
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection excludeWith(Condition condition) {
        return this.exclude(condition);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement find(Condition condition) {
        return CollectionElementByCondition.wrap(this.collection, condition);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement findBy(Condition condition) {
        return this.find(condition);
    }

    @CheckReturnValue
    @Nonnull
    private List<WebElement> getElements() {
        return this.collection.getElements();
    }

    @CheckReturnValue
    @Nonnull
    public List<String> texts() {
        return communicator.texts(this.driver(), this.getElements());
    }

    @CheckReturnValue
    @Nonnull
    @Deprecated
    public static List<String> texts(@Nullable Collection<WebElement> elements) {
        return elements == null ? Collections.emptyList() : elements.stream().map(ElementsCollection::getText).collect(Collectors.toList());
    }

    @Deprecated
    private static String getText(WebElement element) {
        try {
            return element.getText();
        }
        catch (WebDriverException elementDisappeared) {
            return elementDisappeared.toString();
        }
    }

    @CheckReturnValue
    @Nonnull
    public List<String> attributes(String attribute) {
        return communicator.attributes(this.driver(), this.getElements(), attribute);
    }

    @CheckReturnValue
    @Nonnull
    @Deprecated
    public static List<String> attributes(String attribute, Collection<WebElement> elements) {
        return elements.stream().map(e -> ElementsCollection.getAttribute(e, attribute)).collect(Collectors.toList());
    }

    @Deprecated
    private static String getAttribute(WebElement element, String attribute) {
        try {
            return element.getAttribute(attribute);
        }
        catch (WebDriverException elementDisappeared) {
            return elementDisappeared.toString();
        }
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public SelenideElement get(int index) {
        return CollectionElement.wrap(this.collection, index);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement first() {
        return this.get(0);
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement last() {
        return LastCollectionElement.wrap(this.collection);
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection first(int elements) {
        return new ElementsCollection(new HeadOfCollection(this.collection, elements));
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection last(int elements) {
        return new ElementsCollection(new TailOfCollection(this.collection, elements));
    }

    @Override
    @CheckReturnValue
    public int size() {
        try {
            return this.getElements().size();
        }
        catch (IndexOutOfBoundsException outOfCollection) {
            return 0;
        }
    }

    @Override
    @Deprecated
    public Stream<SelenideElement> stream() {
        return super.stream();
    }

    @Override
    @Deprecated
    public Stream<SelenideElement> parallelStream() {
        return super.parallelStream();
    }

    @Override
    @Deprecated
    public void forEach(Consumer<? super SelenideElement> action) {
        super.forEach(action);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    @Deprecated
    public Iterator<SelenideElement> iterator() {
        return this.asFixedIterable().iterator();
    }

    @Override
    @CheckReturnValue
    @Nonnull
    @Deprecated
    public ListIterator<SelenideElement> listIterator(int index) {
        return new SelenideElementListIterator(new CollectionSnapshot(this.collection), index);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    @Deprecated
    public ListIterator<SelenideElement> listIterator() {
        return this.listIterator(0);
    }

    @Override
    @Deprecated
    protected void removeRange(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("You cannot remove elements from web page");
    }

    @Override
    @Deprecated
    public void clear() {
        throw new UnsupportedOperationException("You cannot remove elements from web page");
    }

    @Override
    @CheckReturnValue
    @Nonnull
    @Deprecated
    public List<SelenideElement> subList(int fromIndex, int toIndex) {
        return super.subList(fromIndex, toIndex);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    @Deprecated
    public Object[] toArray() {
        List<WebElement> fetchedElements = this.collection.getElements();
        Object[] result = new Object[fetchedElements.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = CollectionElement.wrap(this.collection, i);
        }
        return result;
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection snapshot() {
        return new ElementsCollection(new CollectionSnapshot(this.collection));
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElementIterable asFixedIterable() {
        return () -> new SelenideElementIterator(new CollectionSnapshot(this.collection));
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElementIterable asDynamicIterable() {
        return () -> new SelenideElementIterator(this.collection);
    }

    @CheckReturnValue
    @Nonnull
    public ElementsCollection as(String alias) {
        this.collection.setAlias(alias);
        return this;
    }

    @Override
    @CheckReturnValue
    public String toString() {
        return this.collection.getAlias().getOrElse(this.collection::toString);
    }

    @CheckReturnValue
    @Nonnull
    private Driver driver() {
        return this.collection.driver();
    }

    public static interface SelenideElementIterable
    extends Iterable<SelenideElement> {
        default public Stream<SelenideElement> stream() {
            return StreamSupport.stream(this.spliterator(), false);
        }
    }
}

