/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.conditions.And;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.ex.ElementShould;
import com.codeborne.selenide.ex.ElementShouldNot;
import com.codeborne.selenide.ex.UIAssertionError;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.Cleanup;
import com.codeborne.selenide.impl.ElementFinder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.By;
import org.openqa.selenium.UnhandledAlertException;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public abstract class WebElementSource {
    @Nonnull
    private Alias alias = Alias.NONE;

    @CheckReturnValue
    @Nonnull
    public abstract Driver driver();

    @CheckReturnValue
    @Nonnull
    public abstract WebElement getWebElement();

    @CheckReturnValue
    @Nonnull
    public abstract String getSearchCriteria();

    public void setAlias(String alias) {
        this.alias = new Alias(alias);
    }

    @CheckReturnValue
    @Nonnull
    public Alias getAlias() {
        return this.alias;
    }

    @CheckReturnValue
    @Nonnull
    public String description() {
        return this.alias.getOrElse(this::getSearchCriteria);
    }

    @CheckReturnValue
    @Nonnull
    public String toString() {
        return this.description();
    }

    @CheckReturnValue
    @Nonnull
    public SelenideElement find(SelenideElement proxy, Object arg, int index) {
        return ElementFinder.wrap(this.driver(), this, WebElementSource.getSelector(arg), index);
    }

    @CheckReturnValue
    @Nonnull
    public List<WebElement> findAll() throws IndexOutOfBoundsException {
        return Collections.singletonList(this.getWebElement());
    }

    @CheckReturnValue
    @Nonnull
    public ElementNotFound createElementNotFoundError(Condition condition, Throwable cause) {
        if (cause instanceof UIAssertionError) {
            throw new IllegalArgumentException("Unexpected UIAssertionError as a cause of ElementNotFound: " + cause, cause);
        }
        return new ElementNotFound(this.driver(), this.alias, this.getSearchCriteria(), condition, cause);
    }

    @CheckReturnValue
    @Nonnull
    public static By getSelector(Object arg) {
        if (arg instanceof By) {
            By by = (By)arg;
            return by;
        }
        if (arg instanceof String) {
            String cssSelector = (String)arg;
            return By.cssSelector((String)cssSelector);
        }
        throw new IllegalArgumentException("Unsupported selector type: " + arg);
    }

    public void checkCondition(String prefix, Condition condition, boolean invert) {
        this.checkConditionAndReturnElement(prefix, condition, invert);
    }

    @Nullable
    @CheckReturnValue
    private WebElement checkConditionAndReturnElement(String prefix, Condition condition, boolean invert) {
        Condition check = invert ? Condition.not(condition) : condition;
        Object lastError = null;
        WebElement element = null;
        CheckResult checkResult = null;
        try {
            element = this.getWebElement();
            checkResult = check.check(this.driver(), element);
            if (checkResult.verdict() == CheckResult.Verdict.ACCEPT) {
                return element;
            }
        }
        catch (AssertionError | IndexOutOfBoundsException | WebDriverException e) {
            lastError = e;
        }
        return this.handleError(prefix, condition, invert, check, (Throwable)lastError, element, checkResult);
    }

    private WebElement handleError(String prefix, Condition condition, boolean invert, Condition check, @Nullable Throwable lastError, @Nullable WebElement element, @Nullable CheckResult checkResult) {
        if (lastError != null && Cleanup.of.isInvalidSelectorError(lastError)) {
            throw Cleanup.of.wrapInvalidSelectorException(lastError);
        }
        if (lastError instanceof UnhandledAlertException) {
            UnhandledAlertException unhandledAlertException = (UnhandledAlertException)lastError;
            throw unhandledAlertException;
        }
        if (element == null) {
            if (check.missingElementSatisfiesCondition()) {
                return null;
            }
            throw this.createElementNotFoundError(check, lastError);
        }
        if (invert) {
            throw new ElementShouldNot(this.driver(), this.getAlias(), this.getSearchCriteria(), prefix, condition, checkResult, element, lastError);
        }
        throw new ElementShould(this.driver(), this.getAlias(), this.getSearchCriteria(), prefix, condition, checkResult, element, lastError);
    }

    @Nonnull
    @CheckReturnValue
    public WebElement findAndAssertElementIsInteractable() {
        return Objects.requireNonNull(this.checkConditionAndReturnElement("be ", Condition.interactable, false));
    }

    @Nonnull
    @CheckReturnValue
    public WebElement findAndAssertElementIsClickable() {
        return Objects.requireNonNull(this.checkConditionAndReturnElement("be ", new And("clickable", Arrays.asList(Condition.interactable, Condition.enabled)), false));
    }

    @Nonnull
    @CheckReturnValue
    public WebElement findAndAssertElementIsEditable() {
        return Objects.requireNonNull(this.checkConditionAndReturnElement("be ", Condition.editable, false));
    }
}

