/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.impl;

import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.SelenideElement;
import com.codeborne.selenide.ex.ElementNotFound;
import com.codeborne.selenide.impl.Alias;
import com.codeborne.selenide.impl.SelenideElementProxy;
import com.codeborne.selenide.impl.WebElementSource;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class LazyWebElementSnapshot
extends WebElementSource {
    private final WebElementSource delegate;
    private WebElement snapshot;

    public static SelenideElement wrap(WebElementSource delegate) {
        return (SelenideElement)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{SelenideElement.class}, (InvocationHandler)new SelenideElementProxy(new LazyWebElementSnapshot(delegate)));
    }

    LazyWebElementSnapshot(WebElementSource delegate) {
        this.delegate = delegate;
    }

    @Override
    @Nonnull
    public Driver driver() {
        return this.delegate.driver();
    }

    @Override
    @Nonnull
    public WebElement getWebElement() {
        if (this.snapshot == null) {
            this.snapshot = this.delegate.getWebElement();
        }
        return this.snapshot;
    }

    @Override
    @Nonnull
    public String getSearchCriteria() {
        return this.delegate.getSearchCriteria();
    }

    @Override
    public void setAlias(String alias) {
        this.delegate.setAlias(alias);
    }

    @Override
    @Nonnull
    public Alias getAlias() {
        return this.delegate.getAlias();
    }

    @Override
    @Nonnull
    public String description() {
        return this.delegate.description();
    }

    @Override
    @Nonnull
    public String toString() {
        return this.delegate.toString();
    }

    @Override
    @Nonnull
    public SelenideElement find(SelenideElement proxy, Object arg, int index) {
        return this.delegate.find(proxy, arg, index);
    }

    @Override
    @Nonnull
    public List<WebElement> findAll() throws IndexOutOfBoundsException {
        return this.delegate.findAll();
    }

    @Override
    @Nonnull
    public ElementNotFound createElementNotFoundError(Condition condition, Throwable cause) {
        return this.delegate.createElementNotFoundError(condition, cause);
    }
}

