/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.drivercommands;

import com.codeborne.selenide.AuthenticationType;
import com.codeborne.selenide.BasicAuthCredentials;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.Credentials;
import com.codeborne.selenide.Driver;
import com.codeborne.selenide.FileDownloadMode;
import com.codeborne.selenide.SelenideDriver;
import com.codeborne.selenide.drivercommands.BasicAuthUtils;
import com.codeborne.selenide.logevents.SelenideLogger;
import com.codeborne.selenide.proxy.AuthenticationFilter;
import com.codeborne.selenide.proxy.SelenideProxyServer;
import java.net.URL;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebDriverException;

@ParametersAreNonnullByDefault
public class Navigator {
    private static final Pattern ABSOLUTE_URL_REGEX = Pattern.compile("^[a-zA-Z-]+:.*", 32);

    public void open(SelenideDriver driver, String relativeOrAbsoluteUrl) {
        this.navigateTo(driver, relativeOrAbsoluteUrl, null, null);
    }

    public void open(SelenideDriver driver, URL url) {
        this.navigateTo(driver, url.toExternalForm(), null, null);
    }

    public void open(SelenideDriver driver, String relativeOrAbsoluteUrl, String domain, String login, String password) {
        this.navigateTo(driver, relativeOrAbsoluteUrl, AuthenticationType.BASIC, new BasicAuthCredentials(domain, login, password));
    }

    public void open(SelenideDriver driver, URL url, String domain, String login, String password) {
        this.navigateTo(driver, url.toExternalForm(), AuthenticationType.BASIC, new BasicAuthCredentials(domain, login, password));
    }

    public void open(SelenideDriver driver, String relativeOrAbsoluteUrl, AuthenticationType authenticationType, Credentials credentials) {
        this.navigateTo(driver, relativeOrAbsoluteUrl, authenticationType, credentials);
    }

    private AuthenticationFilter basicAuthRequestFilter(SelenideProxyServer selenideProxy) {
        return (AuthenticationFilter)selenideProxy.requestFilter("authentication");
    }

    @Nonnull
    String absoluteUrl(Config config, String relativeOrAbsoluteUrl) {
        return this.isAbsoluteUrl(relativeOrAbsoluteUrl) ? relativeOrAbsoluteUrl : config.baseUrl() + relativeOrAbsoluteUrl;
    }

    private void navigateTo(SelenideDriver driver, String relativeOrAbsoluteUrl, @Nullable AuthenticationType authenticationType, @Nullable Credentials credentials) {
        this.checkThatProxyIsEnabled(driver.config());
        String absoluteUrl = this.absoluteUrl(driver.config(), relativeOrAbsoluteUrl);
        SelenideLogger.run("open", absoluteUrl, () -> {
            try {
                WebDriver webDriver = driver.getAndCheckWebDriver();
                String url = this.applyBasicAuthIfNeeded(driver.config(), absoluteUrl, webDriver, authenticationType, credentials);
                this.beforeNavigateTo(driver.config(), driver.getProxy(), authenticationType, credentials);
                webDriver.navigate().to(url);
            }
            catch (WebDriverException e) {
                e.addInfo("selenide.url", absoluteUrl);
                e.addInfo("selenide.baseUrl", driver.config().baseUrl());
                if (driver.config().remote() != null) {
                    e.addInfo("selenide.remote", driver.config().remote());
                }
                throw e;
            }
        });
    }

    public void open(SelenideDriver driver) {
        this.checkThatProxyIsEnabled(driver.config());
        SelenideLogger.run("open", "", driver::getAndCheckWebDriver);
    }

    private void checkThatProxyIsEnabled(Config config) {
        if (!config.proxyEnabled() && config.fileDownload() == FileDownloadMode.PROXY) {
            throw new IllegalStateException("config.proxyEnabled == false but config.fileDownload == PROXY. You need to enable proxy server automatically.");
        }
    }

    private void checkThatProxyIsStarted(@Nullable SelenideProxyServer selenideProxy) {
        if (selenideProxy == null) {
            throw new IllegalStateException("config.proxyEnabled == true but proxy server is not created. You need to call `setWebDriver(webDriver, selenideProxy)` instead of `setWebDriver(webDriver)` if you need to use proxy.");
        }
        if (!selenideProxy.isStarted()) {
            throw new IllegalStateException("config.proxyEnabled == true but proxy server is not started.");
        }
    }

    private void beforeNavigateTo(Config config, @Nullable SelenideProxyServer selenideProxy, @Nullable AuthenticationType authenticationType, @Nullable Credentials credentials) {
        if (config.proxyEnabled()) {
            this.checkThatProxyIsStarted(selenideProxy);
            this.beforeNavigateToWithProxy(selenideProxy, authenticationType, credentials);
        } else {
            this.beforeNavigateToWithoutProxy(authenticationType, credentials);
        }
    }

    private void beforeNavigateToWithProxy(SelenideProxyServer selenideProxy, @Nullable AuthenticationType authenticationType, @Nullable Credentials credentials) {
        if (authenticationType != null && credentials != null) {
            this.basicAuthRequestFilter(selenideProxy).setAuthentication(authenticationType, credentials);
        } else {
            this.basicAuthRequestFilter(selenideProxy).removeAuthentication();
        }
    }

    private void beforeNavigateToWithoutProxy(@Nullable AuthenticationType authenticationType, @Nullable Credentials credentials) {
        if (credentials != null && authenticationType != AuthenticationType.BASIC) {
            throw new UnsupportedOperationException("Cannot use " + (Object)((Object)authenticationType) + " authentication without proxy server");
        }
    }

    private String applyBasicAuthIfNeeded(Config config, String url, WebDriver webDriver, @Nullable AuthenticationType authType, @Nullable Credentials credentials) {
        if (BasicAuthUtils.registerBasicAuth(webDriver, credentials)) {
            return url;
        }
        return this.passBasicAuthThroughUrl(config, authType, credentials) ? BasicAuthUtils.appendBasicAuthToURL(url, (BasicAuthCredentials)credentials) : url;
    }

    private boolean passBasicAuthThroughUrl(Config config, @Nullable AuthenticationType authenticationType, @Nullable Credentials credentials) {
        return authenticationType == AuthenticationType.BASIC && credentials != null && !config.proxyEnabled();
    }

    boolean isAbsoluteUrl(String relativeOrAbsoluteUrl) {
        return ABSOLUTE_URL_REGEX.matcher(relativeOrAbsoluteUrl).matches();
    }

    public void back(Driver driver) {
        SelenideLogger.run("back", "", () -> driver.getWebDriver().navigate().back());
    }

    public void forward(Driver driver) {
        SelenideLogger.run("forward", "", () -> driver.getWebDriver().navigate().forward());
    }

    public void refresh(Driver driver) {
        SelenideLogger.run("refresh", "", () -> driver.getWebDriver().navigate().refresh());
    }
}

