/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.webdriver;

import com.codeborne.selenide.ObjectCondition;
import com.codeborne.selenide.impl.JavaScript;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;

@ParametersAreNonnullByDefault
public abstract class CurrentFrameCondition
implements ObjectCondition<WebDriver> {
    private final String name;
    protected final String expectedUrl;

    protected CurrentFrameCondition(String name, String expectedUrl) {
        this.name = name;
        this.expectedUrl = expectedUrl;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String description() {
        return "should have url " + this.name + this.expectedUrl;
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public String negativeDescription() {
        return "should not have url " + this.name + this.expectedUrl;
    }

    @Override
    @CheckReturnValue
    @Nullable
    public String actualValue(WebDriver webDriver) {
        return this.getCurrentFrameUrl(webDriver);
    }

    @Override
    @Nullable
    @CheckReturnValue
    public String expectedValue() {
        return this.expectedUrl;
    }

    @CheckReturnValue
    @Nonnull
    protected String getCurrentFrameUrl(WebDriver webDriver) {
        return JavaScript.jsExecutor((SearchContext)webDriver).executeScript("return window.location.href", new Object[0]).toString();
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String describe(WebDriver webDriver) {
        return "current frame";
    }
}

