/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions.webdriver;

import com.codeborne.selenide.ObjectCondition;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.openqa.selenium.WebDriver;

@ParametersAreNonnullByDefault
public class CookieWithName
implements ObjectCondition<WebDriver> {
    private final String name;

    public CookieWithName(String name) {
        this.name = name;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String description() {
        return String.format("should have a cookie with name \"%s\"", this.name);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String negativeDescription() {
        return String.format("should not have cookie with name \"%s\"", this.name);
    }

    @Override
    @CheckReturnValue
    public boolean test(WebDriver webDriver) {
        return Objects.nonNull(webDriver.manage().getCookieNamed(this.name));
    }

    @Override
    @Nullable
    @CheckReturnValue
    public String actualValue(WebDriver webDriver) {
        return String.format("Available cookies: %s", webDriver.manage().getCookies());
    }

    @Override
    @Nullable
    @CheckReturnValue
    public String expectedValue() {
        return String.format("cookie with name \"%s\"", this.name);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String describe(@Nonnull WebDriver webDriver) {
        return "webdriver";
    }
}

