/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide.conditions;

import com.codeborne.selenide.CheckResult;
import com.codeborne.selenide.Condition;
import com.codeborne.selenide.Driver;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;

@ParametersAreNonnullByDefault
public class PseudoElementPropertyWithValue
extends Condition {
    static final String JS_CODE = "return window.getComputedStyle(arguments[0], arguments[1]).getPropertyValue(arguments[2]);";
    private final String pseudoElementName;
    private final String propertyName;
    private final String expectedPropertyValue;

    public PseudoElementPropertyWithValue(String pseudoElementName, String propertyName, String expectedPropertyValue) {
        super("pseudo-element");
        this.pseudoElementName = pseudoElementName;
        this.propertyName = propertyName;
        this.expectedPropertyValue = expectedPropertyValue;
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public CheckResult check(Driver driver, WebElement element) {
        String value = this.getPseudoElementPropertyValue(driver, element);
        return new CheckResult(StringUtils.defaultString((String)this.expectedPropertyValue).equalsIgnoreCase(value), (Object)this.actualValue(value));
    }

    private String actualValue(String pseudoElementValue) {
        return String.format("%s {%s: %s;}", this.pseudoElementName, this.propertyName, pseudoElementValue);
    }

    @Override
    @Nonnull
    @CheckReturnValue
    public String toString() {
        return String.format("%s %s {%s: %s;}", this.getName(), this.pseudoElementName, this.propertyName, this.expectedPropertyValue);
    }

    private String getPseudoElementPropertyValue(Driver driver, WebElement element) {
        String propertyValue = (String)driver.executeJavaScript(JS_CODE, element, this.pseudoElementName, this.propertyName);
        return propertyValue == null ? "" : propertyValue;
    }
}

