/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.SetValueMethod;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class SetValueOptions {
    private static final Pattern REGEX_ANY_CHAR = Pattern.compile(".");
    private static final Formats DATE = new Formats(DateTimeFormatter.ofPattern("yyyy-MM-dd"), DateTimeFormatter.ofPattern("dd.MM.yyyy"));
    private static final Formats DATETIME = new Formats(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSS"), DateTimeFormatter.ofPattern("dd.MM.yyyy HH:mm"));
    private static final Formats TIME = new Formats(DateTimeFormatter.ofPattern("HH:mm:ss.SSS"), DateTimeFormatter.ofPattern("HH:mm"));
    private final CharSequence value;
    private final CharSequence displayedText;
    private final SetValueMethod method;

    protected SetValueOptions(SetValueMethod method, CharSequence value, CharSequence displayedText) {
        this.method = method;
        this.value = value;
        this.displayedText = displayedText;
    }

    @CheckReturnValue
    @Nonnull
    public static SetValueOptions withText(CharSequence text) {
        return new SetValueOptions(SetValueMethod.SEND_KEYS, text, text);
    }

    @CheckReturnValue
    @Nonnull
    public static SetValueOptions withDate(LocalDate date) {
        return new SetValueOptions(SetValueMethod.JS, DATE.value(date), DATE.display(date));
    }

    @CheckReturnValue
    @Nonnull
    public static SetValueOptions withDateTime(LocalDateTime dateTime) {
        return new SetValueOptions(SetValueMethod.JS, DATETIME.value(dateTime), DATETIME.display(dateTime));
    }

    @CheckReturnValue
    @Nonnull
    public static SetValueOptions withTime(LocalTime time) {
        return new SetValueOptions(SetValueMethod.JS, TIME.value(time), TIME.display(time));
    }

    @CheckReturnValue
    @Nonnull
    public SetValueOptions withDisplayedText(CharSequence displayedText) {
        return new SetValueOptions(this.method, this.value, displayedText);
    }

    @CheckReturnValue
    @Nonnull
    public SetValueOptions usingMethod(SetValueMethod method) {
        return new SetValueOptions(method, this.value, this.displayedText);
    }

    @CheckReturnValue
    public CharSequence value() {
        return this.value;
    }

    @CheckReturnValue
    @Nonnull
    public SetValueMethod method() {
        return this.method;
    }

    @CheckReturnValue
    @Nonnull
    public SetValueOptions sensitive() {
        return new SetValueOptions(this.method, this.value, this.mask(this.value));
    }

    @Nonnull
    @CheckReturnValue
    private String mask(CharSequence text) {
        return REGEX_ANY_CHAR.matcher(text).replaceAll("*");
    }

    public String toString() {
        if (this.method == SetValueMethod.SEND_KEYS) {
            return this.displayedText.toString();
        }
        return String.format("\"%s\" (feat. %s)", new Object[]{this.displayedText, this.method});
    }

    private static final class Formats {
        private final DateTimeFormatter valueFormat;
        private final DateTimeFormatter displayFormat;

        private Formats(DateTimeFormatter valueFormat, DateTimeFormatter displayFormat) {
            this.valueFormat = valueFormat;
            this.displayFormat = displayFormat;
        }

        String value(TemporalAccessor date) {
            return this.valueFormat.format(date);
        }

        String display(TemporalAccessor date) {
            return this.displayFormat.format(date);
        }

        public String toString() {
            return "Formats[" + "valueFormat=" + this.valueFormat + "," + "displayFormat=" + this.displayFormat + "]";
        }

        public int hashCode() {
            int result = 0;
            result = 31 * result + (this.valueFormat != null ? this.valueFormat.hashCode() : 0);
            result = 31 * result + (this.displayFormat != null ? this.displayFormat.hashCode() : 0);
            return result;
        }

        public final boolean equals(Object arg0) {
            if (this == arg0) {
                return true;
            }
            if (arg0 == null) {
                return false;
            }
            if (arg0.getClass() != this.getClass()) {
                return false;
            }
            if (!Objects.equals(((Formats)arg0).valueFormat, this.valueFormat)) {
                return false;
            }
            return Objects.equals(((Formats)arg0).displayFormat, this.displayFormat);
            {
            }
        }

        public DateTimeFormatter valueFormat() {
            return this.valueFormat;
        }

        public DateTimeFormatter displayFormat() {
            return this.displayFormat;
        }
    }
}

