/*
 * Decompiled with CFR 0.152.
 */
package com.codeborne.selenide;

import com.codeborne.selenide.AssertionMode;
import com.codeborne.selenide.Config;
import com.codeborne.selenide.FileDownloadMode;
import com.codeborne.selenide.PropertiesReader;
import com.codeborne.selenide.SelectorMode;
import com.codeborne.selenide.TextCheck;
import com.codeborne.selenide.impl.CiReportUrl;
import org.openqa.selenium.MutableCapabilities;

public class SelenideConfig
implements Config {
    private final PropertiesReader properties = new PropertiesReader("selenide.properties");
    private String browser = this.getProperty("selenide.browser", "chrome");
    private boolean headless = Boolean.parseBoolean(this.getProperty("selenide.headless", "false"));
    private String remote = this.getProperty("selenide.remote", null);
    private String browserSize = this.getProperty("selenide.browserSize", "1366x768");
    private String browserVersion = this.getProperty("selenide.browserVersion", null);
    private String browserPosition = this.getProperty("selenide.browserPosition", null);
    private boolean driverManagerEnabled = Boolean.parseBoolean(this.getProperty("selenide.driverManagerEnabled", "true"));
    private boolean webdriverLogsEnabled = Boolean.parseBoolean(this.getProperty("selenide.webdriverLogsEnabled", "false"));
    private String browserBinary = this.getProperty("selenide.browserBinary", null);
    private String pageLoadStrategy = this.getProperty("selenide.pageLoadStrategy", "normal");
    private long pageLoadTimeout = Long.parseLong(this.getProperty("selenide.pageLoadTimeout", "30000"));
    private MutableCapabilities browserCapabilities = new MutableCapabilities();
    private String baseUrl = this.getProperty("selenide.baseUrl", "http://localhost:8080");
    private long timeout = Long.parseLong(this.getProperty("selenide.timeout", "4000"));
    private long pollingInterval = Long.parseLong(this.getProperty("selenide.pollingInterval", "200"));
    private boolean holdBrowserOpen = Boolean.parseBoolean(this.getProperty("selenide.holdBrowserOpen", "false"));
    private boolean reopenBrowserOnFail = Boolean.parseBoolean(this.getProperty("selenide.reopenBrowserOnFail", "true"));
    private boolean clickViaJs = Boolean.parseBoolean(this.getProperty("selenide.clickViaJs", "false"));
    private boolean screenshots = Boolean.parseBoolean(this.getProperty("selenide.screenshots", "true"));
    private boolean savePageSource = Boolean.parseBoolean(this.getProperty("selenide.savePageSource", "true"));
    private String reportsFolder = this.getProperty("selenide.reportsFolder", "build/reports/tests");
    private String downloadsFolder = this.getProperty("selenide.downloadsFolder", "build/downloads");
    private String reportsUrl = new CiReportUrl().getReportsUrl(this.getProperty("selenide.reportsUrl", null));
    private boolean fastSetValue = Boolean.parseBoolean(this.getProperty("selenide.fastSetValue", "false"));
    private TextCheck textCheck = TextCheck.valueOf(this.getProperty("selenide.textCheck", TextCheck.PARTIAL_TEXT.name()));
    private SelectorMode selectorMode = SelectorMode.valueOf(this.getProperty("selenide.selectorMode", SelectorMode.CSS.name()));
    private AssertionMode assertionMode = AssertionMode.valueOf(this.getProperty("selenide.assertionMode", AssertionMode.STRICT.name()));
    private FileDownloadMode fileDownload = FileDownloadMode.valueOf(this.getProperty("selenide.fileDownload", FileDownloadMode.HTTPGET.name()));
    private boolean proxyEnabled = Boolean.parseBoolean(this.getProperty("selenide.proxyEnabled", "false"));
    private String proxyHost = this.getProperty("selenide.proxyHost", null);
    private int proxyPort = Integer.parseInt(this.getProperty("selenide.proxyPort", "0"));
    private long remoteReadTimeout = Long.parseLong(this.getProperty("selenide.remoteReadTimeout", "90000"));
    private long remoteConnectionTimeout = Long.parseLong(this.getProperty("selenide.remoteConnectionTimeout", "10000"));

    @Override
    public String baseUrl() {
        return this.baseUrl;
    }

    public SelenideConfig baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    @Override
    public long timeout() {
        return this.timeout;
    }

    public SelenideConfig timeout(long timeout) {
        this.timeout = timeout;
        return this;
    }

    @Override
    public long pollingInterval() {
        return this.pollingInterval;
    }

    public SelenideConfig pollingInterval(long pollingInterval) {
        this.pollingInterval = pollingInterval;
        return this;
    }

    @Override
    public boolean holdBrowserOpen() {
        return this.holdBrowserOpen;
    }

    public SelenideConfig holdBrowserOpen(boolean holdBrowserOpen) {
        this.holdBrowserOpen = holdBrowserOpen;
        return this;
    }

    @Override
    public boolean reopenBrowserOnFail() {
        return this.reopenBrowserOnFail;
    }

    public SelenideConfig reopenBrowserOnFail(boolean reopenBrowserOnFail) {
        this.reopenBrowserOnFail = reopenBrowserOnFail;
        return this;
    }

    @Override
    public boolean clickViaJs() {
        return this.clickViaJs;
    }

    public SelenideConfig clickViaJs(boolean clickViaJs) {
        this.clickViaJs = clickViaJs;
        return this;
    }

    @Override
    public boolean screenshots() {
        return this.screenshots;
    }

    public SelenideConfig screenshots(boolean screenshots) {
        this.screenshots = screenshots;
        return this;
    }

    @Override
    public boolean savePageSource() {
        return this.savePageSource;
    }

    public SelenideConfig savePageSource(boolean savePageSource) {
        this.savePageSource = savePageSource;
        return this;
    }

    @Override
    public String reportsFolder() {
        return this.reportsFolder;
    }

    public SelenideConfig reportsFolder(String reportsFolder) {
        this.reportsFolder = reportsFolder;
        return this;
    }

    @Override
    public String downloadsFolder() {
        return this.downloadsFolder;
    }

    public SelenideConfig downloadsFolder(String downloadsFolder) {
        this.downloadsFolder = downloadsFolder;
        return this;
    }

    @Override
    public String reportsUrl() {
        return this.reportsUrl;
    }

    public SelenideConfig reportsUrl(String reportsUrl) {
        this.reportsUrl = reportsUrl;
        return this;
    }

    @Override
    public boolean fastSetValue() {
        return this.fastSetValue;
    }

    @Override
    public TextCheck textCheck() {
        return this.textCheck;
    }

    public SelenideConfig fastSetValue(boolean fastSetValue) {
        this.fastSetValue = fastSetValue;
        return this;
    }

    public SelenideConfig textCheck(TextCheck textCheck) {
        this.textCheck = textCheck;
        return this;
    }

    @Override
    public SelectorMode selectorMode() {
        return this.selectorMode;
    }

    public SelenideConfig selectorMode(SelectorMode selectorMode) {
        this.selectorMode = selectorMode;
        return this;
    }

    @Override
    public AssertionMode assertionMode() {
        return this.assertionMode;
    }

    public SelenideConfig assertionMode(AssertionMode assertionMode) {
        this.assertionMode = assertionMode;
        return this;
    }

    @Override
    public FileDownloadMode fileDownload() {
        return this.fileDownload;
    }

    public SelenideConfig fileDownload(FileDownloadMode fileDownload) {
        this.fileDownload = fileDownload;
        return this;
    }

    @Override
    public boolean proxyEnabled() {
        return this.proxyEnabled;
    }

    public SelenideConfig proxyEnabled(boolean proxyEnabled) {
        this.proxyEnabled = proxyEnabled;
        return this;
    }

    @Override
    public String proxyHost() {
        return this.proxyHost;
    }

    public SelenideConfig proxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
        return this;
    }

    @Override
    public int proxyPort() {
        return this.proxyPort;
    }

    public SelenideConfig proxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
        return this;
    }

    @Override
    public String browser() {
        return this.browser;
    }

    public SelenideConfig browser(String browser) {
        this.browser = browser;
        return this;
    }

    @Override
    public boolean headless() {
        return this.headless;
    }

    public SelenideConfig headless(boolean headless) {
        this.headless = headless;
        return this;
    }

    @Override
    public String remote() {
        return this.remote;
    }

    public SelenideConfig remote(String remote) {
        this.remote = remote;
        return this;
    }

    @Override
    public String browserSize() {
        return this.browserSize;
    }

    public SelenideConfig browserSize(String browserSize) {
        this.browserSize = browserSize;
        return this;
    }

    @Override
    public String browserVersion() {
        return this.browserVersion;
    }

    public SelenideConfig browserVersion(String browserVersion) {
        this.browserVersion = browserVersion;
        return this;
    }

    @Override
    public String browserPosition() {
        return this.browserPosition;
    }

    public SelenideConfig browserPosition(String browserPosition) {
        this.browserPosition = browserPosition;
        return this;
    }

    @Override
    public boolean driverManagerEnabled() {
        return this.driverManagerEnabled;
    }

    public SelenideConfig driverManagerEnabled(boolean driverManagerEnabled) {
        this.driverManagerEnabled = driverManagerEnabled;
        return this;
    }

    @Override
    public boolean webdriverLogsEnabled() {
        return this.webdriverLogsEnabled;
    }

    public SelenideConfig webdriverLogsEnabled(boolean webdriverLogsEnabled) {
        this.webdriverLogsEnabled = webdriverLogsEnabled;
        return this;
    }

    @Override
    public String browserBinary() {
        return this.browserBinary;
    }

    public SelenideConfig browserBinary(String browserBinary) {
        this.browserBinary = browserBinary;
        return this;
    }

    @Override
    public String pageLoadStrategy() {
        return this.pageLoadStrategy;
    }

    @Override
    public long pageLoadTimeout() {
        return this.pageLoadTimeout;
    }

    public SelenideConfig pageLoadStrategy(String pageLoadStrategy) {
        this.pageLoadStrategy = pageLoadStrategy;
        return this;
    }

    public SelenideConfig pageLoadTimeout(long pageLoadTimeout) {
        this.pageLoadTimeout = pageLoadTimeout;
        return this;
    }

    @Override
    public MutableCapabilities browserCapabilities() {
        return this.browserCapabilities;
    }

    public SelenideConfig browserCapabilities(MutableCapabilities browserCapabilities) {
        this.browserCapabilities = browserCapabilities;
        return this;
    }

    private String getProperty(String key, String defaultValue) {
        String value = this.properties.getProperty(key, defaultValue);
        if (value != null && value.trim().isEmpty() && defaultValue == null) {
            return null;
        }
        return value;
    }

    @Override
    public long remoteReadTimeout() {
        return this.remoteReadTimeout;
    }

    public SelenideConfig remoteReadTimeout(long remoteReadTimeout) {
        this.remoteReadTimeout = remoteReadTimeout;
        return this;
    }

    @Override
    public long remoteConnectionTimeout() {
        return this.remoteConnectionTimeout;
    }

    public SelenideConfig remoteConnectionTimeout(long remoteConnectionTimeout) {
        this.remoteConnectionTimeout = remoteConnectionTimeout;
        return this;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

