/*
 * Decompiled with CFR 0.152.
 */
package com.codearms.maoqiqi.lazyload;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;

public abstract class LazyLoadFragment
extends Fragment {
    private final String TAG = ((Object)((Object)this)).getClass().getSimpleName();
    protected Context context;
    protected View rootView;
    private boolean isReuse = true;
    private boolean isVisible = false;
    private boolean isViewCreated = false;
    private boolean isLoadDataCompleted = false;
    private boolean isForcedToRefresh = false;

    public void setUserVisibleHint(boolean isVisibleToUser) {
        super.setUserVisibleHint(isVisibleToUser);
        Log.d((String)this.TAG, (String)("-->setUserVisibleHint(boolean isVisibleToUser) = " + isVisibleToUser));
        if (this.isViewCreated) {
            if (this.isVisible != isVisibleToUser) {
                this.isVisible = isVisibleToUser;
                this.onVisibleChange(this.isVisible);
            }
            if (this.isVisible && (!this.isLoadDataCompleted || this.isForcedToRefresh)) {
                this.isLoadDataCompleted = true;
                this.loadData();
            }
        }
    }

    public void onInflate(Context context, AttributeSet attrs, Bundle savedInstanceState) {
        super.onInflate(context, attrs, savedInstanceState);
        Log.d((String)this.TAG, (String)"-->onInflate(Context context, AttributeSet attrs, Bundle savedInstanceState)");
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        Log.d((String)this.TAG, (String)"-->onAttach(Context context)");
        this.context = context;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Log.d((String)this.TAG, (String)"-->onCreate(@Nullable Bundle savedInstanceState)");
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        super.onCreateView(inflater, container, savedInstanceState);
        Log.d((String)this.TAG, (String)"-->onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState)");
        if (!this.isReuse || this.rootView == null) {
            Log.d((String)this.TAG, (String)"-->\u521b\u5efaView");
            this.rootView = this.createView(inflater, container);
            this.initViews(savedInstanceState);
        } else {
            Log.d((String)this.TAG, (String)"-->\u590d\u7528View");
        }
        return this.rootView;
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        Log.d((String)this.TAG, (String)"-->onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState)");
        this.isViewCreated = true;
    }

    public void onActivityCreated(@Nullable Bundle savedInstanceState) {
        super.onActivityCreated(savedInstanceState);
        Log.d((String)this.TAG, (String)"-->onActivityCreated(@Nullable Bundle savedInstanceState)");
        if (this.getUserVisibleHint()) {
            if (!this.isVisible) {
                this.isVisible = true;
                this.onVisibleChange(true);
            }
            if (!this.isLoadDataCompleted || this.isForcedToRefresh) {
                this.isLoadDataCompleted = true;
                this.loadData();
            }
        }
    }

    public void onViewStateRestored(@Nullable Bundle savedInstanceState) {
        super.onViewStateRestored(savedInstanceState);
        Log.d((String)this.TAG, (String)"-->onViewStateRestored(@Nullable Bundle savedInstanceState)");
    }

    public void onStart() {
        super.onStart();
        Log.d((String)this.TAG, (String)"-->onStart()");
    }

    public void onResume() {
        super.onResume();
        Log.d((String)this.TAG, (String)"-->onResume()");
    }

    public void onPause() {
        super.onPause();
        Log.d((String)this.TAG, (String)"-->onPause()");
    }

    public void onSaveInstanceState(@NonNull Bundle outState) {
        super.onSaveInstanceState(outState);
        Log.d((String)this.TAG, (String)"-->onSaveInstanceState(@NonNull Bundle outState)");
    }

    public void onStop() {
        super.onStop();
        Log.d((String)this.TAG, (String)"-->onStop()");
    }

    public void onDestroyView() {
        super.onDestroyView();
        Log.d((String)this.TAG, (String)"-->onDestroyView()");
        this.isViewCreated = false;
        if (!this.isReuse) {
            this.rootView = null;
        }
    }

    public void onDestroy() {
        super.onDestroy();
        Log.d((String)this.TAG, (String)"-->onDestroy()");
        this.rootView = null;
    }

    public void onDetach() {
        super.onDetach();
        Log.d((String)this.TAG, (String)"-->onDetach()");
        this.context = null;
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Log.d((String)this.TAG, (String)"-->onConfigurationChanged(Configuration newConfig)");
    }

    public void onHiddenChanged(boolean hidden) {
        super.onHiddenChanged(hidden);
        Log.d((String)this.TAG, (String)("-->onHiddenChanged(boolean hidden) = " + hidden));
    }

    protected abstract View createView(@NonNull LayoutInflater var1, @Nullable ViewGroup var2);

    protected void initViews(@Nullable Bundle savedInstanceState) {
    }

    protected void onVisibleChange(boolean isVisible) {
        Log.d((String)this.TAG, (String)("-->onVisibleChange(boolean isVisible) = " + isVisible));
    }

    protected void loadData() {
        Log.d((String)this.TAG, (String)"-->loadData()");
    }

    public void setReuse(boolean reuse) {
        this.isReuse = reuse;
    }

    public void setForcedToRefresh(boolean forcedToRefresh) {
        this.isForcedToRefresh = forcedToRefresh;
    }
}

