/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public final class ZipUtils {
    private ZipUtils() {
    }

    public static Set<String> mergeZipToZip(String src, ZipOutputStream zos, Set<String> skipFiles) throws IOException {
        HashSet<String> filesAdded = new HashSet<String>();
        try (JarFile jarFile = new JarFile(src);){
            Enumeration<JarEntry> allEntries = jarFile.entries();
            while (allEntries.hasMoreElements()) {
                JarEntry entry = allEntries.nextElement();
                if (skipFiles != null && skipFiles.contains(entry.getName())) continue;
                zos.putNextEntry(new ZipEntry(entry.getName()));
                InputStream is = jarFile.getInputStream(entry);
                try {
                    byte[] buf = new byte[1024];
                    int i = 0;
                    while ((i = is.read(buf)) != -1) {
                        zos.write(buf, 0, i);
                    }
                    zos.closeEntry();
                    filesAdded.add(entry.getName());
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        return filesAdded;
    }

    public static Set<String> mergeDirectoryToZip(String src, final ZipOutputStream zos, final Set<String> skipFiles) throws IllegalArgumentException, IOException {
        final HashSet<String> filesAdded = new HashSet<String>();
        final File sourceDir = new File(src);
        if (!sourceDir.isDirectory()) {
            throw new IllegalArgumentException("Argument src must be a directory. Path provided: " + src);
        }
        Files.walkFileTree(sourceDir.toPath(), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String zipPath = sourceDir.toPath().relativize(file).toString();
                if (skipFiles.stream().anyMatch(zipPath::endsWith)) {
                    return FileVisitResult.CONTINUE;
                }
                zos.putNextEntry(new ZipEntry(zipPath));
                Files.copy(file, zos);
                filesAdded.add(zipPath);
                return FileVisitResult.CONTINUE;
            }
        });
        return filesAdded;
    }

    public static void extractFile(String srcZip, String targetFile, String outputFilePath) throws IOException {
        try (FileOutputStream out = new FileOutputStream(outputFilePath);
             ZipInputStream zis = new ZipInputStream(new FileInputStream(srcZip));){
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                if (ze.getName().equals(targetFile)) {
                    byte[] buf = new byte[1024];
                    int read = 0;
                    while ((read = zis.read(buf)) > -1) {
                        ((OutputStream)out).write(buf, 0, read);
                    }
                    ((OutputStream)out).close();
                    break;
                }
                ze = zis.getNextEntry();
            }
        }
    }
}

