/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter;

import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter.IFilter;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter.IFilterContext;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter.IFilterOutput;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter.KotlinCoroutineFilter;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter.KotlinDefaultArgumentsFilter;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter.KotlinGeneratedFilter;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.tree.MethodNode;

public final class SyntheticFilter
implements IFilter {
    private static boolean isScalaClass(IFilterContext context) {
        return context.getClassAttributes().contains("ScalaSig") || context.getClassAttributes().contains("Scala");
    }

    @Override
    public void filter(MethodNode methodNode, IFilterContext context, IFilterOutput output) {
        if ((methodNode.access & 0x1000) == 0) {
            return;
        }
        if (methodNode.name.startsWith("lambda$")) {
            return;
        }
        if (SyntheticFilter.isScalaClass(context) && methodNode.name.startsWith("$anonfun$")) {
            return;
        }
        if (KotlinGeneratedFilter.isKotlinClass(context)) {
            if (KotlinDefaultArgumentsFilter.isDefaultArgumentsMethod(methodNode)) {
                return;
            }
            if (KotlinDefaultArgumentsFilter.isDefaultArgumentsConstructor(methodNode)) {
                return;
            }
            if (KotlinCoroutineFilter.isImplementationOfSuspendFunction(methodNode)) {
                return;
            }
        }
        output.ignore(methodNode.instructions.getFirst(), methodNode.instructions.getLast());
    }
}

