/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis;

import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.ClassCoverageImpl;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.InstructionsBuilder;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.MethodAnalyzer;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.MethodCoverageCalculator;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.MethodCoverageImpl;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.StringPool;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter.Filters;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter.IFilter;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.filter.IFilterContext;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.flow.ClassProbesVisitor;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.flow.MethodProbesVisitor;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.instr.InstrSupport;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.AnnotationVisitor;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.Attribute;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.FieldVisitor;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.MethodVisitor;
import com.code_intelligence.jazzer.third_party.org.objectweb.asm.tree.MethodNode;
import java.util.HashSet;
import java.util.Set;

public class ClassAnalyzer
extends ClassProbesVisitor
implements IFilterContext {
    private final ClassCoverageImpl coverage;
    private final boolean[] probes;
    private final StringPool stringPool;
    private final Set<String> classAnnotations = new HashSet<String>();
    private final Set<String> classAttributes = new HashSet<String>();
    private String sourceDebugExtension;
    private final IFilter filter;

    public ClassAnalyzer(ClassCoverageImpl coverage, boolean[] probes, StringPool stringPool) {
        this.coverage = coverage;
        this.probes = probes;
        this.stringPool = stringPool;
        this.filter = Filters.all();
    }

    @Override
    public void visit(int version, int access, String name, String signature2, String superName, String[] interfaces) {
        this.coverage.setSignature(this.stringPool.get(signature2));
        this.coverage.setSuperName(this.stringPool.get(superName));
        this.coverage.setInterfaces(this.stringPool.get(interfaces));
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        this.classAnnotations.add(desc);
        return super.visitAnnotation(desc, visible);
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        this.classAttributes.add(attribute.type);
    }

    @Override
    public void visitSource(String source, String debug) {
        this.coverage.setSourceFileName(this.stringPool.get(source));
        this.sourceDebugExtension = debug;
    }

    @Override
    public MethodProbesVisitor visitMethod(int access, final String name, final String desc, final String signature2, String[] exceptions) {
        InstrSupport.assertNotInstrumented(name, this.coverage.getName());
        final InstructionsBuilder builder = new InstructionsBuilder(this.probes);
        return new MethodAnalyzer(builder){

            @Override
            public void accept(MethodNode methodNode, MethodVisitor methodVisitor) {
                super.accept(methodNode, methodVisitor);
                ClassAnalyzer.this.addMethodCoverage(ClassAnalyzer.this.stringPool.get(name), ClassAnalyzer.this.stringPool.get(desc), ClassAnalyzer.this.stringPool.get(signature2), builder, methodNode);
            }
        };
    }

    private void addMethodCoverage(String name, String desc, String signature2, InstructionsBuilder icc, MethodNode methodNode) {
        MethodCoverageCalculator mcc = new MethodCoverageCalculator(icc.getInstructions());
        this.filter.filter(methodNode, this, mcc);
        MethodCoverageImpl mc = new MethodCoverageImpl(name, desc, signature2);
        mcc.calculate(mc);
        if (mc.containsCode()) {
            this.coverage.addMethod(mc);
        }
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature2, Object value) {
        InstrSupport.assertNotInstrumented(name, this.coverage.getName());
        return super.visitField(access, name, desc, signature2, value);
    }

    @Override
    public void visitTotalProbeCount(int count) {
    }

    @Override
    public String getClassName() {
        return this.coverage.getName();
    }

    @Override
    public String getSuperClassName() {
        return this.coverage.getSuperName();
    }

    @Override
    public Set<String> getClassAnnotations() {
        return this.classAnnotations;
    }

    @Override
    public Set<String> getClassAttributes() {
        return this.classAttributes;
    }

    @Override
    public String getSourceFileName() {
        return this.coverage.getSourceFileName();
    }

    @Override
    public String getSourceDebugExtension() {
        return this.sourceDebugExtension;
    }
}

