/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.third_party.org.jacoco.core.analysis;

import com.code_intelligence.jazzer.third_party.org.jacoco.core.analysis.ICounter;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.analysis.ICoverageNode;
import com.code_intelligence.jazzer.third_party.org.jacoco.core.internal.analysis.CounterImpl;
import java.util.Collection;

public class CoverageNodeImpl
implements ICoverageNode {
    private final ICoverageNode.ElementType elementType;
    private final String name;
    protected CounterImpl branchCounter;
    protected CounterImpl instructionCounter;
    protected CounterImpl lineCounter;
    protected CounterImpl complexityCounter;
    protected CounterImpl methodCounter;
    protected CounterImpl classCounter;

    public CoverageNodeImpl(ICoverageNode.ElementType elementType, String name) {
        this.elementType = elementType;
        this.name = name;
        this.branchCounter = CounterImpl.COUNTER_0_0;
        this.instructionCounter = CounterImpl.COUNTER_0_0;
        this.complexityCounter = CounterImpl.COUNTER_0_0;
        this.methodCounter = CounterImpl.COUNTER_0_0;
        this.classCounter = CounterImpl.COUNTER_0_0;
        this.lineCounter = CounterImpl.COUNTER_0_0;
    }

    public void increment(ICoverageNode child) {
        this.instructionCounter = this.instructionCounter.increment(child.getInstructionCounter());
        this.branchCounter = this.branchCounter.increment(child.getBranchCounter());
        this.lineCounter = this.lineCounter.increment(child.getLineCounter());
        this.complexityCounter = this.complexityCounter.increment(child.getComplexityCounter());
        this.methodCounter = this.methodCounter.increment(child.getMethodCounter());
        this.classCounter = this.classCounter.increment(child.getClassCounter());
    }

    public void increment(Collection<? extends ICoverageNode> children) {
        for (ICoverageNode iCoverageNode : children) {
            this.increment(iCoverageNode);
        }
    }

    @Override
    public ICoverageNode.ElementType getElementType() {
        return this.elementType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public ICounter getInstructionCounter() {
        return this.instructionCounter;
    }

    @Override
    public ICounter getBranchCounter() {
        return this.branchCounter;
    }

    @Override
    public ICounter getLineCounter() {
        return this.lineCounter;
    }

    @Override
    public ICounter getComplexityCounter() {
        return this.complexityCounter;
    }

    @Override
    public ICounter getMethodCounter() {
        return this.methodCounter;
    }

    @Override
    public ICounter getClassCounter() {
        return this.classCounter;
    }

    @Override
    public ICounter getCounter(ICoverageNode.CounterEntity entity) {
        switch (entity) {
            case INSTRUCTION: {
                return this.getInstructionCounter();
            }
            case BRANCH: {
                return this.getBranchCounter();
            }
            case LINE: {
                return this.getLineCounter();
            }
            case COMPLEXITY: {
                return this.getComplexityCounter();
            }
            case METHOD: {
                return this.getMethodCounter();
            }
            case CLASS: {
                return this.getClassCounter();
            }
        }
        throw new AssertionError((Object)entity);
    }

    @Override
    public boolean containsCode() {
        return this.getInstructionCounter().getTotalCount() != 0;
    }

    @Override
    public ICoverageNode getPlainCopy() {
        CoverageNodeImpl copy2 = new CoverageNodeImpl(this.elementType, this.name);
        copy2.instructionCounter = CounterImpl.getInstance(this.instructionCounter);
        copy2.branchCounter = CounterImpl.getInstance(this.branchCounter);
        copy2.lineCounter = CounterImpl.getInstance(this.lineCounter);
        copy2.complexityCounter = CounterImpl.getInstance(this.complexityCounter);
        copy2.methodCounter = CounterImpl.getInstance(this.methodCounter);
        copy2.classCounter = CounterImpl.getInstance(this.classCounter);
        return copy2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.name).append(" [").append((Object)this.elementType).append("]");
        return sb.toString();
    }
}

