/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation.mutator.collection;

import com.code_intelligence.jazzer.mutation.annotation.WithSize;
import com.code_intelligence.jazzer.mutation.api.Debuggable;
import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.PseudoRandom;
import com.code_intelligence.jazzer.mutation.api.SerializingInPlaceMutator;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.mutator.collection.ChunkCrossOvers;
import com.code_intelligence.jazzer.mutation.mutator.collection.ChunkMutations;
import com.code_intelligence.jazzer.mutation.support.Preconditions;
import com.code_intelligence.jazzer.mutation.support.RandomSupport;
import com.code_intelligence.jazzer.mutation.support.StreamSupport;
import com.code_intelligence.jazzer.mutation.support.TypeSupport;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedType;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

final class MapMutatorFactory
extends MutatorFactory {
    MapMutatorFactory() {
    }

    @Override
    public Optional<SerializingMutator<?>> tryCreate(AnnotatedType type2, MutatorFactory factory) {
        return TypeSupport.parameterTypesIfParameterized(type2, Map.class).map(parameterTypes -> parameterTypes.stream().map(factory::tryCreate).flatMap(StreamSupport::getOrEmpty).collect(Collectors.toList())).map(elementMutators -> {
            Preconditions.check(elementMutators.size() == 2);
            int min = 0;
            int max = 1000;
            for (Annotation annotation : type2.getDeclaredAnnotations()) {
                if (!(annotation instanceof WithSize)) continue;
                WithSize withSize = (WithSize)annotation;
                min = withSize.min();
                max = withSize.max();
            }
            return new MapMutator((SerializingMutator)elementMutators.get(0), (SerializingMutator)elementMutators.get(1), min, max);
        });
    }

    private static final class MapMutator<K, V>
    extends SerializingInPlaceMutator<Map<K, V>> {
        private static final int DEFAULT_MIN_SIZE = 0;
        private static final int DEFAULT_MAX_SIZE = 1000;
        private final SerializingMutator<K> keyMutator;
        private final SerializingMutator<V> valueMutator;
        private final int minSize;
        private final int maxSize;

        MapMutator(SerializingMutator<K> keyMutator, SerializingMutator<V> valueMutator, int minSize, int maxSize) {
            this.keyMutator = keyMutator;
            this.valueMutator = valueMutator;
            this.minSize = Math.max(minSize, 0);
            this.maxSize = Math.min(maxSize, 1000);
            Preconditions.require(maxSize >= 1, String.format("WithSize#max=%d needs to be greater than 0", maxSize));
            Preconditions.require(minSize == 0, "@WithSize#min != 0 is not yet supported for Map");
        }

        @Override
        public Map<K, V> read(DataInputStream in) throws IOException {
            int size = RandomSupport.clamp(in.readInt(), this.minSize, this.maxSize);
            LinkedHashMap map = new LinkedHashMap(size);
            for (int i = 0; i < size; ++i) {
                map.put(this.keyMutator.read(in), this.valueMutator.read(in));
            }
            return map;
        }

        @Override
        public void write(Map<K, V> map, DataOutputStream out) throws IOException {
            out.writeInt(map.size());
            for (Map.Entry<K, V> entry : map.entrySet()) {
                this.keyMutator.write(entry.getKey(), out);
                this.valueMutator.write(entry.getValue(), out);
            }
        }

        @Override
        protected Map<K, V> makeDefaultInstance() {
            return new LinkedHashMap(this.maxInitialSize());
        }

        @Override
        public void initInPlace(Map<K, V> map, PseudoRandom prng) {
            int targetSize = prng.closedRange(this.minInitialSize(), this.maxInitialSize());
            map.clear();
            ChunkMutations.growBy(map.keySet(), key -> map.putIfAbsent(key, this.valueMutator.init(prng)), targetSize, () -> this.keyMutator.init(prng));
            if (map.size() < this.minSize) {
                throw new IllegalStateException(String.format("Failed to create %d distinct elements of type %s to satisfy the @WithSize#minSize constraint on Map", this.minSize, this.keyMutator));
            }
        }

        @Override
        public void mutateInPlace(Map<K, V> map, PseudoRandom prng) {
            switch (ChunkMutations.MutationAction.pickRandomMutationAction(map.keySet(), this.minSize, this.maxSize, prng)) {
                case DELETE_CHUNK: {
                    ChunkMutations.deleteRandomChunk(map.keySet(), this.minSize, prng, this.entriesHaveFixedSize());
                    break;
                }
                case INSERT_CHUNK: {
                    ChunkMutations.insertRandomChunk(map.keySet(), key -> map.putIfAbsent(key, this.valueMutator.init(prng)), this.maxSize, this.keyMutator, prng);
                    break;
                }
                case MUTATE_CHUNK: {
                    if (!prng.choice() && ChunkMutations.mutateRandomKeysChunk(map, this.keyMutator, prng)) break;
                    ChunkMutations.mutateRandomValuesChunk(map, this.valueMutator, prng);
                    break;
                }
                default: {
                    throw new IllegalStateException("unsupported action");
                }
            }
        }

        @Override
        public void crossOverInPlace(Map<K, V> reference, Map<K, V> otherReference, PseudoRandom prng) {
            switch (ChunkCrossOvers.CrossOverAction.pickRandomCrossOverAction(reference.keySet(), otherReference.keySet(), this.maxSize, prng)) {
                case INSERT_CHUNK: {
                    ChunkCrossOvers.insertChunk(reference, otherReference, this.maxSize, prng, this.entriesHaveFixedSize());
                    break;
                }
                case OVERWRITE_CHUNK: {
                    ChunkCrossOvers.overwriteChunk(reference, otherReference, prng, this.entriesHaveFixedSize());
                    break;
                }
                case CROSS_OVER_CHUNK: {
                    ChunkCrossOvers.crossOverChunk(reference, otherReference, this.keyMutator, this.valueMutator, prng);
                    break;
                }
            }
        }

        private boolean entriesHaveFixedSize() {
            return this.keyMutator.hasFixedSize() && this.valueMutator.hasFixedSize();
        }

        @Override
        public boolean hasFixedSize() {
            return false;
        }

        @Override
        public Map<K, V> detach(Map<K, V> value) {
            return value.entrySet().stream().collect(Collectors.toMap(entry -> this.keyMutator.detach(entry.getKey()), entry -> this.valueMutator.detach(entry.getValue())));
        }

        @Override
        public String toDebugString(Predicate<Debuggable> isInCycle) {
            return "Map<" + this.keyMutator.toDebugString(isInCycle) + "," + this.valueMutator.toDebugString(isInCycle) + ">";
        }

        private int minInitialSize() {
            return this.minSize;
        }

        private int maxInitialSize() {
            return Math.min(this.maxSize, this.minSize + 1);
        }
    }
}

