/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.mutation;

import com.code_intelligence.jazzer.mutation.api.MutatorFactory;
import com.code_intelligence.jazzer.mutation.api.PseudoRandom;
import com.code_intelligence.jazzer.mutation.api.SerializingMutator;
import com.code_intelligence.jazzer.mutation.combinator.MutatorCombinators;
import com.code_intelligence.jazzer.mutation.combinator.ProductMutator;
import com.code_intelligence.jazzer.mutation.engine.SeededPseudoRandom;
import com.code_intelligence.jazzer.mutation.mutator.Mutators;
import com.code_intelligence.jazzer.mutation.support.Preconditions;
import com.code_intelligence.jazzer.mutation.support.StreamSupport;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.AnnotatedType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;

public final class ArgumentsMutator {
    private final Method method;
    private final ProductMutator productMutator;
    private Object[] arguments;
    private boolean argumentsExposed;

    private ArgumentsMutator(Method method, ProductMutator productMutator) {
        this.method = method;
        this.productMutator = productMutator;
    }

    private static String prettyPrintMethod(Method method) {
        return String.format("%s.%s(%s)", method.getDeclaringClass().getName(), method.getName(), Arrays.stream(method.getAnnotatedParameterTypes()).map(Object::toString).collect(Collectors.joining(", ")));
    }

    public static ArgumentsMutator forMethodOrThrow(Method method) {
        return ArgumentsMutator.forMethod(Mutators.newFactory(), method).orElseThrow(() -> new IllegalArgumentException("Failed to construct mutator for " + ArgumentsMutator.prettyPrintMethod(method)));
    }

    public static Optional<ArgumentsMutator> forMethod(Method method) {
        return ArgumentsMutator.forMethod(Mutators.newFactory(), method);
    }

    public static Optional<ArgumentsMutator> forMethod(MutatorFactory mutatorFactory, Method method) {
        Preconditions.require(method.getParameterCount() > 0, "Can't fuzz method without parameters: " + method);
        for (AnnotatedType parameter : method.getAnnotatedParameterTypes()) {
            Mutators.validateAnnotationUsage(parameter);
        }
        return StreamSupport.toArrayOrEmpty(Arrays.stream(method.getAnnotatedParameterTypes()).map(mutatorFactory::tryCreate), SerializingMutator[]::new).map(MutatorCombinators::mutateProduct).map(productMutator -> ArgumentsMutator.create(method, productMutator));
    }

    private static ArgumentsMutator create(Method method, ProductMutator productMutator) {
        method.setAccessible(true);
        return new ArgumentsMutator(method, productMutator);
    }

    public void crossOver(InputStream data1, InputStream data2, long seed) {
        try {
            Object[] objects1 = this.productMutator.readExclusive(data1);
            Object[] objects2 = this.productMutator.readExclusive(data2);
            SeededPseudoRandom prng = new SeededPseudoRandom(seed);
            this.arguments = this.productMutator.crossOver(objects1, objects2, prng);
            this.argumentsExposed = false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void read(ByteArrayInputStream data2) {
        try {
            this.arguments = this.productMutator.readExclusive(data2);
            this.argumentsExposed = false;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void write(OutputStream data2) {
        this.failIfArgumentsExposed();
        this.writeAny(data2, this.arguments);
    }

    public void writeAny(OutputStream data2, Object[] args2) throws UncheckedIOException {
        try {
            this.productMutator.writeExclusive(args2, data2);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void init(long seed) {
        this.init(new SeededPseudoRandom(seed));
    }

    void init(PseudoRandom prng) {
        this.arguments = (Object[])this.productMutator.init(prng);
        this.argumentsExposed = false;
    }

    public void mutate(long seed) {
        this.mutate(new SeededPseudoRandom(seed));
    }

    void mutate(PseudoRandom prng) {
        this.failIfArgumentsExposed();
        this.productMutator.mutateInPlace(this.arguments, prng);
    }

    public void invoke(Object instance, boolean detach) throws Throwable {
        Object[] invokeArguments;
        if (detach) {
            invokeArguments = this.productMutator.detach(this.arguments);
        } else {
            invokeArguments = this.arguments;
            this.argumentsExposed = true;
        }
        try {
            this.method.invoke(instance, invokeArguments);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("method should have been made accessible", e);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    public Object[] getArguments() {
        this.argumentsExposed = true;
        return this.arguments;
    }

    public String toString() {
        return "Arguments" + this.productMutator;
    }

    private void failIfArgumentsExposed() {
        Preconditions.check(!this.argumentsExposed, "Arguments have previously been exposed to user-provided code without calling #detach and may have been modified");
    }
}

