/*
 * Decompiled with CFR 0.152.
 */
package com.code_intelligence.jazzer.api;

import com.code_intelligence.jazzer.api.AutofuzzConstructionException;
import com.code_intelligence.jazzer.api.AutofuzzInvocationException;
import com.code_intelligence.jazzer.api.Consumer1;
import com.code_intelligence.jazzer.api.Consumer2;
import com.code_intelligence.jazzer.api.Consumer3;
import com.code_intelligence.jazzer.api.Consumer4;
import com.code_intelligence.jazzer.api.Consumer5;
import com.code_intelligence.jazzer.api.Function1;
import com.code_intelligence.jazzer.api.Function2;
import com.code_intelligence.jazzer.api.Function3;
import com.code_intelligence.jazzer.api.Function4;
import com.code_intelligence.jazzer.api.Function5;
import com.code_intelligence.jazzer.api.FuzzedDataProvider;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;

public final class Autofuzz {
    private static final MethodHandle CONSUME;
    private static final MethodHandle AUTOFUZZ_FUNCTION_1;
    private static final MethodHandle AUTOFUZZ_FUNCTION_2;
    private static final MethodHandle AUTOFUZZ_FUNCTION_3;
    private static final MethodHandle AUTOFUZZ_FUNCTION_4;
    private static final MethodHandle AUTOFUZZ_FUNCTION_5;
    private static final MethodHandle AUTOFUZZ_CONSUMER_1;
    private static final MethodHandle AUTOFUZZ_CONSUMER_2;
    private static final MethodHandle AUTOFUZZ_CONSUMER_3;
    private static final MethodHandle AUTOFUZZ_CONSUMER_4;
    private static final MethodHandle AUTOFUZZ_CONSUMER_5;

    private Autofuzz() {
    }

    public static <T1, R> R autofuzz(FuzzedDataProvider data, Function1<T1, R> func) {
        try {
            return (R)AUTOFUZZ_FUNCTION_1.invoke(data, func);
        }
        catch (AutofuzzInvocationException e) {
            Autofuzz.rethrowUnchecked(e.getCause());
        }
        catch (Throwable t) {
            Autofuzz.rethrowUnchecked(t);
        }
        return null;
    }

    public static <T1, T2, R> R autofuzz(FuzzedDataProvider data, Function2<T1, T2, R> func) {
        try {
            return (R)AUTOFUZZ_FUNCTION_2.invoke(data, func);
        }
        catch (AutofuzzInvocationException e) {
            Autofuzz.rethrowUnchecked(e.getCause());
        }
        catch (Throwable t) {
            Autofuzz.rethrowUnchecked(t);
        }
        return null;
    }

    public static <T1, T2, T3, R> R autofuzz(FuzzedDataProvider data, Function3<T1, T2, T3, R> func) {
        try {
            return (R)AUTOFUZZ_FUNCTION_3.invoke(data, func);
        }
        catch (AutofuzzInvocationException e) {
            Autofuzz.rethrowUnchecked(e.getCause());
        }
        catch (Throwable t) {
            Autofuzz.rethrowUnchecked(t);
        }
        return null;
    }

    public static <T1, T2, T3, T4, R> R autofuzz(FuzzedDataProvider data, Function4<T1, T2, T3, T4, R> func) {
        try {
            return (R)AUTOFUZZ_FUNCTION_4.invoke(data, func);
        }
        catch (AutofuzzInvocationException e) {
            Autofuzz.rethrowUnchecked(e.getCause());
        }
        catch (Throwable t) {
            Autofuzz.rethrowUnchecked(t);
        }
        return null;
    }

    public static <T1, T2, T3, T4, T5, R> R autofuzz(FuzzedDataProvider data, Function5<T1, T2, T3, T4, T5, R> func) {
        try {
            return (R)AUTOFUZZ_FUNCTION_5.invoke(data, func);
        }
        catch (AutofuzzInvocationException e) {
            Autofuzz.rethrowUnchecked(e.getCause());
        }
        catch (Throwable t) {
            Autofuzz.rethrowUnchecked(t);
        }
        return null;
    }

    public static <T1> void autofuzz(FuzzedDataProvider data, Consumer1<T1> func) {
        try {
            AUTOFUZZ_CONSUMER_1.invoke(data, func);
        }
        catch (AutofuzzInvocationException e) {
            Autofuzz.rethrowUnchecked(e.getCause());
        }
        catch (Throwable t) {
            Autofuzz.rethrowUnchecked(t);
        }
    }

    public static <T1, T2> void autofuzz(FuzzedDataProvider data, Consumer2<T1, T2> func) {
        try {
            AUTOFUZZ_CONSUMER_2.invoke(data, func);
        }
        catch (AutofuzzInvocationException e) {
            Autofuzz.rethrowUnchecked(e.getCause());
        }
        catch (Throwable t) {
            Autofuzz.rethrowUnchecked(t);
        }
    }

    public static <T1, T2, T3> void autofuzz(FuzzedDataProvider data, Consumer3<T1, T2, T3> func) {
        try {
            AUTOFUZZ_CONSUMER_3.invoke(data, func);
        }
        catch (AutofuzzInvocationException e) {
            Autofuzz.rethrowUnchecked(e.getCause());
        }
        catch (Throwable t) {
            Autofuzz.rethrowUnchecked(t);
        }
    }

    public static <T1, T2, T3, T4> void autofuzz(FuzzedDataProvider data, Consumer4<T1, T2, T3, T4> func) {
        try {
            AUTOFUZZ_CONSUMER_4.invoke(data, func);
        }
        catch (AutofuzzInvocationException e) {
            Autofuzz.rethrowUnchecked(e.getCause());
        }
        catch (Throwable t) {
            Autofuzz.rethrowUnchecked(t);
        }
    }

    public static <T1, T2, T3, T4, T5> void autofuzz(FuzzedDataProvider data, Consumer5<T1, T2, T3, T4, T5> func) {
        try {
            AUTOFUZZ_CONSUMER_5.invoke(data, func);
        }
        catch (AutofuzzInvocationException e) {
            Autofuzz.rethrowUnchecked(e.getCause());
        }
        catch (Throwable t) {
            Autofuzz.rethrowUnchecked(t);
        }
    }

    public static <T> T consume(FuzzedDataProvider data, Class<T> type) {
        try {
            return (T)CONSUME.invokeExact(data, type);
        }
        catch (AutofuzzConstructionException ignored) {
            return null;
        }
        catch (Throwable t) {
            Autofuzz.rethrowUnchecked(t);
            return null;
        }
    }

    private static <T extends Throwable> void rethrowUnchecked(Throwable t) throws T {
        throw t;
    }

    static {
        MethodHandle consume = null;
        MethodHandle autofuzzFunction1 = null;
        MethodHandle autofuzzFunction2 = null;
        MethodHandle autofuzzFunction3 = null;
        MethodHandle autofuzzFunction4 = null;
        MethodHandle autofuzzFunction5 = null;
        MethodHandle autofuzzConsumer1 = null;
        MethodHandle autofuzzConsumer2 = null;
        MethodHandle autofuzzConsumer3 = null;
        MethodHandle autofuzzConsumer4 = null;
        MethodHandle autofuzzConsumer5 = null;
        try {
            Class<?> metaClass = Class.forName("com.code_intelligence.jazzer.autofuzz.Meta");
            MethodType consumeType = MethodType.methodType(Object.class, FuzzedDataProvider.class, Class.class);
            consume = MethodHandles.publicLookup().findStatic(metaClass, "consume", consumeType);
            autofuzzFunction1 = MethodHandles.publicLookup().findStatic(metaClass, "autofuzz", MethodType.methodType(Object.class, FuzzedDataProvider.class, Function1.class));
            autofuzzFunction2 = MethodHandles.publicLookup().findStatic(metaClass, "autofuzz", MethodType.methodType(Object.class, FuzzedDataProvider.class, Function2.class));
            autofuzzFunction3 = MethodHandles.publicLookup().findStatic(metaClass, "autofuzz", MethodType.methodType(Object.class, FuzzedDataProvider.class, Function3.class));
            autofuzzFunction4 = MethodHandles.publicLookup().findStatic(metaClass, "autofuzz", MethodType.methodType(Object.class, FuzzedDataProvider.class, Function4.class));
            autofuzzFunction5 = MethodHandles.publicLookup().findStatic(metaClass, "autofuzz", MethodType.methodType(Object.class, FuzzedDataProvider.class, Function5.class));
            autofuzzConsumer1 = MethodHandles.publicLookup().findStatic(metaClass, "autofuzz", MethodType.methodType(Void.TYPE, FuzzedDataProvider.class, Consumer1.class));
            autofuzzConsumer2 = MethodHandles.publicLookup().findStatic(metaClass, "autofuzz", MethodType.methodType(Void.TYPE, FuzzedDataProvider.class, Consumer2.class));
            autofuzzConsumer3 = MethodHandles.publicLookup().findStatic(metaClass, "autofuzz", MethodType.methodType(Void.TYPE, FuzzedDataProvider.class, Consumer3.class));
            autofuzzConsumer4 = MethodHandles.publicLookup().findStatic(metaClass, "autofuzz", MethodType.methodType(Void.TYPE, FuzzedDataProvider.class, Consumer4.class));
            autofuzzConsumer5 = MethodHandles.publicLookup().findStatic(metaClass, "autofuzz", MethodType.methodType(Void.TYPE, FuzzedDataProvider.class, Consumer5.class));
        }
        catch (ClassNotFoundException metaClass) {
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            System.err.println("ERROR: Incompatible version of the Jazzer API detected, please update.");
            e.printStackTrace();
            System.exit(1);
        }
        CONSUME = consume;
        AUTOFUZZ_FUNCTION_1 = autofuzzFunction1;
        AUTOFUZZ_FUNCTION_2 = autofuzzFunction2;
        AUTOFUZZ_FUNCTION_3 = autofuzzFunction3;
        AUTOFUZZ_FUNCTION_4 = autofuzzFunction4;
        AUTOFUZZ_FUNCTION_5 = autofuzzFunction5;
        AUTOFUZZ_CONSUMER_1 = autofuzzConsumer1;
        AUTOFUZZ_CONSUMER_2 = autofuzzConsumer2;
        AUTOFUZZ_CONSUMER_3 = autofuzzConsumer3;
        AUTOFUZZ_CONSUMER_4 = autofuzzConsumer4;
        AUTOFUZZ_CONSUMER_5 = autofuzzConsumer5;
    }
}

