/*
 * Decompiled with CFR 0.152.
 */
package com.codahale.metrics.servlet;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public abstract class WebappMetricsFilter
implements Filter {
    private final String otherMetricName;
    private final Map<Integer, String> meterNamesByStatusCode;
    private final String registryAttribute;
    private ConcurrentMap<Integer, Meter> metersByStatusCode;
    private Meter otherMeter;
    private Counter activeRequests;
    private Timer requestTimer;

    protected WebappMetricsFilter(String registryAttribute, Map<Integer, String> meterNamesByStatusCode, String otherMetricName) {
        this.registryAttribute = registryAttribute;
        this.otherMetricName = otherMetricName;
        this.meterNamesByStatusCode = meterNamesByStatusCode;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        MetricRegistry metricsRegistry = this.getMetricsFactory(filterConfig);
        this.metersByStatusCode = new ConcurrentHashMap<Integer, Meter>(this.meterNamesByStatusCode.size());
        for (Map.Entry<Integer, String> entry : this.meterNamesByStatusCode.entrySet()) {
            this.metersByStatusCode.put(entry.getKey(), metricsRegistry.meter(MetricRegistry.name(WebappMetricsFilter.class, (String[])new String[]{entry.getValue()})));
        }
        this.otherMeter = metricsRegistry.meter(MetricRegistry.name(WebappMetricsFilter.class, (String[])new String[]{this.otherMetricName}));
        this.activeRequests = metricsRegistry.counter(MetricRegistry.name(WebappMetricsFilter.class, (String[])new String[]{"activeRequests"}));
        this.requestTimer = metricsRegistry.timer(MetricRegistry.name(WebappMetricsFilter.class, (String[])new String[]{"requests"}));
    }

    private MetricRegistry getMetricsFactory(FilterConfig filterConfig) {
        Object o = filterConfig.getServletContext().getAttribute(this.registryAttribute);
        MetricRegistry metricsRegistry = o instanceof MetricRegistry ? (MetricRegistry)o : new MetricRegistry();
        return metricsRegistry;
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        StatusExposingServletResponse wrappedResponse = new StatusExposingServletResponse((HttpServletResponse)response);
        this.activeRequests.inc();
        Timer.Context context = this.requestTimer.time();
        try {
            chain.doFilter(request, (ServletResponse)wrappedResponse);
        }
        finally {
            context.stop();
            this.activeRequests.dec();
            this.markMeterForStatusCode(wrappedResponse.getStatus());
        }
    }

    private void markMeterForStatusCode(int status) {
        Meter metric = (Meter)this.metersByStatusCode.get(status);
        if (metric != null) {
            metric.mark();
        } else {
            this.otherMeter.mark();
        }
    }

    private static class StatusExposingServletResponse
    extends HttpServletResponseWrapper {
        private int httpStatus = 200;

        public StatusExposingServletResponse(HttpServletResponse response) {
            super(response);
        }

        public void sendError(int sc) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc, msg);
        }

        public void setStatus(int sc) {
            this.httpStatus = sc;
            super.setStatus(sc);
        }

        public int getStatus() {
            return this.httpStatus;
        }
    }
}

