/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.feather;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import uk.ac.bristol.star.feather.Buf;
import uk.ac.bristol.star.feather.BufUtils;
import uk.ac.bristol.star.feather.FeatherType;
import uk.ac.bristol.star.feather.Reader;

public abstract class Decoder<T> {
    private final Class<T> clazz_;
    private final FeatherType ftype_;
    private static final Map<FeatherType, Decoder<?>> TYPE_DECODERS = Decoder.createTypeDecoders();
    private static final Logger logger_ = Logger.getLogger(Decoder.class.getName());

    private Decoder(Class<T> clazz, FeatherType featherType) {
        this.clazz_ = clazz;
        this.ftype_ = featherType;
    }

    public abstract Reader<T> createReader(Buf var1, long var2);

    public Class<T> getValueClass() {
        return this.clazz_;
    }

    public FeatherType getFeatherType() {
        return this.ftype_;
    }

    public String toString() {
        return this.ftype_.toString();
    }

    public static Decoder<?> getDecoder(FeatherType featherType) {
        Decoder<?> decoder = TYPE_DECODERS.get(featherType);
        if (decoder != null) {
            return decoder;
        }
        logger_.warning("No decoder for data type " + featherType);
        return new UnsupportedDecoder(featherType);
    }

    private static Map<FeatherType, Decoder<?>> createTypeDecoders() {
        Decoder[] decoderArray = new Decoder[]{new Decoder<Boolean>(Boolean.class, FeatherType.BOOL){

            @Override
            public Reader<Boolean> createReader(final Buf buf, long l) {
                return new AbstractReader<Boolean>(Boolean.class){

                    private boolean get(long l) {
                        return buf.isBitSet(l);
                    }

                    @Override
                    public Boolean getObject(long l) {
                        return this.get(l);
                    }

                    @Override
                    public byte getByte(long l) {
                        return this.get(l) ? (byte)1 : 0;
                    }

                    @Override
                    public short getShort(long l) {
                        return this.get(l) ? (short)1 : 0;
                    }

                    @Override
                    public int getInt(long l) {
                        return this.get(l) ? 1 : 0;
                    }

                    @Override
                    public long getLong(long l) {
                        return this.get(l) ? 1L : 0L;
                    }

                    @Override
                    public float getFloat(long l) {
                        return this.get(l) ? 1.0f : 0.0f;
                    }

                    @Override
                    public double getDouble(long l) {
                        return this.get(l) ? 1.0 : 0.0;
                    }
                };
            }
        }, new Decoder<Byte>(Byte.class, FeatherType.INT8){

            @Override
            public Reader<Byte> createReader(final Buf buf, long l) {
                return new AbstractReader<Byte>(Byte.class){

                    private byte get(long l) {
                        return buf.get(l);
                    }

                    @Override
                    public Byte getObject(long l) {
                        return this.get(l);
                    }

                    @Override
                    public byte getByte(long l) {
                        return this.get(l);
                    }

                    @Override
                    public short getShort(long l) {
                        return this.get(l);
                    }

                    @Override
                    public int getInt(long l) {
                        return this.get(l);
                    }

                    @Override
                    public long getLong(long l) {
                        return this.get(l);
                    }

                    @Override
                    public float getFloat(long l) {
                        return this.get(l);
                    }

                    @Override
                    public double getDouble(long l) {
                        return this.get(l);
                    }
                };
            }
        }, new Decoder<Short>(Short.class, FeatherType.INT16){

            @Override
            public Reader<Short> createReader(final Buf buf, long l) {
                return new ShortReader(){

                    @Override
                    short get(long l) {
                        return buf.getLittleEndianShort(2L * l);
                    }
                };
            }
        }, new Decoder<Integer>(Integer.class, FeatherType.INT32){

            @Override
            public Reader<Integer> createReader(final Buf buf, long l) {
                return new IntReader(){

                    @Override
                    int get(long l) {
                        return buf.getLittleEndianInt(4L * l);
                    }
                };
            }
        }, new Decoder<Long>(Long.class, FeatherType.INT64){

            @Override
            public Reader<Long> createReader(final Buf buf, long l) {
                return new LongReader(){

                    @Override
                    long get(long l) {
                        return buf.getLittleEndianLong(8L * l);
                    }
                };
            }
        }, new Decoder<Short>(Short.class, FeatherType.UINT8){

            @Override
            public Reader<Short> createReader(final Buf buf, long l) {
                return new ShortReader(){

                    @Override
                    short get(long l) {
                        return (short)(0xFF & buf.get(l));
                    }
                };
            }
        }, new Decoder<Integer>(Integer.class, FeatherType.UINT16){

            @Override
            public Reader<Integer> createReader(final Buf buf, long l) {
                return new IntReader(){

                    @Override
                    int get(long l) {
                        return 0xFFFF & buf.getLittleEndianShort(2L * l);
                    }
                };
            }
        }, new Decoder<Long>(Long.class, FeatherType.UINT32){

            @Override
            public Reader<Long> createReader(final Buf buf, long l) {
                return new LongReader(){

                    @Override
                    long get(long l) {
                        return 0xFFFFFFFFL & (long)buf.getLittleEndianInt(4L * l);
                    }
                };
            }
        }, new UnsupportedDecoder(FeatherType.UINT64), new Decoder<Float>(Float.class, FeatherType.FLOAT){

            @Override
            public Reader<Float> createReader(final Buf buf, long l) {
                return new AbstractReader<Float>(Float.class){

                    private float get(long l) {
                        return buf.getLittleEndianFloat(4L * l);
                    }

                    @Override
                    public Float getObject(long l) {
                        return Float.valueOf(this.get(l));
                    }

                    @Override
                    public byte getByte(long l) {
                        return (byte)this.get(l);
                    }

                    @Override
                    public short getShort(long l) {
                        return (short)this.get(l);
                    }

                    @Override
                    public int getInt(long l) {
                        return (int)this.get(l);
                    }

                    @Override
                    public long getLong(long l) {
                        return (long)this.get(l);
                    }

                    @Override
                    public float getFloat(long l) {
                        return this.get(l);
                    }

                    @Override
                    public double getDouble(long l) {
                        return this.get(l);
                    }
                };
            }
        }, new Decoder<Double>(Double.class, FeatherType.DOUBLE){

            @Override
            public Reader<Double> createReader(final Buf buf, long l) {
                return new AbstractReader<Double>(Double.class){

                    private double get(long l) {
                        return buf.getLittleEndianDouble(8L * l);
                    }

                    @Override
                    public Double getObject(long l) {
                        return this.get(l);
                    }

                    @Override
                    public byte getByte(long l) {
                        return (byte)this.get(l);
                    }

                    @Override
                    public short getShort(long l) {
                        return (short)this.get(l);
                    }

                    @Override
                    public int getInt(long l) {
                        return (int)this.get(l);
                    }

                    @Override
                    public long getLong(long l) {
                        return (long)this.get(l);
                    }

                    @Override
                    public float getFloat(long l) {
                        return (float)this.get(l);
                    }

                    @Override
                    public double getDouble(long l) {
                        return this.get(l);
                    }
                };
            }
        }, new Decoder<String>(String.class, FeatherType.UTF8){

            @Override
            public Reader<String> createReader(Buf buf, long l) {
                return new VariableLengthReader32<String>(String.class, buf, l){

                    @Override
                    public String getObject(long l) {
                        return new String(this.getBytes(l), BufUtils.UTF8);
                    }
                };
            }
        }, new Decoder<byte[]>(byte[].class, FeatherType.BINARY){

            @Override
            public Reader<byte[]> createReader(Buf buf, long l) {
                return new VariableLengthReader32<byte[]>(byte[].class, buf, l){

                    @Override
                    public byte[] getObject(long l) {
                        return this.getBytes(l);
                    }
                };
            }
        }, new Decoder<String>(String.class, FeatherType.LARGE_UTF8){

            @Override
            public Reader<String> createReader(Buf buf, long l) {
                return new VariableLengthReader64<String>(String.class, buf, l){

                    @Override
                    public String getObject(long l) {
                        return new String(this.getBytes(l), BufUtils.UTF8);
                    }
                };
            }
        }, new Decoder<byte[]>(byte[].class, FeatherType.LARGE_BINARY){

            @Override
            public Reader<byte[]> createReader(Buf buf, long l) {
                return new VariableLengthReader64<byte[]>(byte[].class, buf, l){

                    @Override
                    public byte[] getObject(long l) {
                        return this.getBytes(l);
                    }
                };
            }
        }, new UnsupportedDecoder(FeatherType.CATEGORY), new Decoder<Long>(Long.class, FeatherType.TIMESTAMP){

            @Override
            public Reader<Long> createReader(final Buf buf, long l) {
                return new LongReader(){

                    @Override
                    long get(long l) {
                        return buf.getLittleEndianLong(8L * l);
                    }
                };
            }
        }, new Decoder<Integer>(Integer.class, FeatherType.DATE){

            @Override
            public Reader<Integer> createReader(final Buf buf, long l) {
                return new IntReader(){

                    @Override
                    int get(long l) {
                        return buf.getLittleEndianInt(4L * l);
                    }
                };
            }
        }, new Decoder<Long>(Long.class, FeatherType.TIME){

            @Override
            public Reader<Long> createReader(final Buf buf, long l) {
                return new LongReader(){

                    @Override
                    long get(long l) {
                        return buf.getLittleEndianLong(8L * l);
                    }
                };
            }
        }};
        LinkedHashMap<FeatherType, Decoder> linkedHashMap = new LinkedHashMap<FeatherType, Decoder>();
        for (Decoder decoder : decoderArray) {
            FeatherType featherType = decoder.ftype_;
            assert (!linkedHashMap.containsKey(featherType));
            linkedHashMap.put(featherType, decoder);
        }
        assert (linkedHashMap.keySet().equals(new HashSet<FeatherType>(Arrays.asList(FeatherType.ALL_TYPES))));
        return Collections.unmodifiableMap(linkedHashMap);
    }

    private static class UnsupportedDecoder
    extends Decoder<Void> {
        private static Reader<Void> dummyReader_;

        UnsupportedDecoder(FeatherType featherType) {
            super(Void.class, featherType);
            dummyReader_ = new NonNumericReader<Void>(Void.class){

                @Override
                public Void getObject(long l) {
                    return null;
                }
            };
        }

        @Override
        public Reader<Void> createReader(Buf buf, long l) {
            return dummyReader_;
        }

        @Override
        public String toString() {
            return this.getFeatherType() + "(unsupported)";
        }
    }

    private static abstract class VariableLengthReader64<T>
    extends VariableLengthReader<T> {
        VariableLengthReader64(Class<T> clazz, Buf buf, long l) {
            super(clazz, buf, l, 8);
        }

        @Override
        long readPointer(long l) {
            return this.buf_.getLittleEndianLong(l);
        }
    }

    private static abstract class VariableLengthReader32<T>
    extends VariableLengthReader<T> {
        VariableLengthReader32(Class<T> clazz, Buf buf, long l) {
            super(clazz, buf, l, 4);
        }

        @Override
        long readPointer(long l) {
            return this.buf_.getLittleEndianInt(l);
        }
    }

    private static abstract class VariableLengthReader<T>
    extends NonNumericReader<T> {
        final int ptrSize_;
        final Buf buf_;
        final long data0_;

        VariableLengthReader(Class<T> clazz, Buf buf, long l, int n) {
            super(clazz);
            this.buf_ = buf;
            this.ptrSize_ = n;
            this.data0_ = BufUtils.ceil8((l + 1L) * (long)this.ptrSize_);
        }

        abstract long readPointer(long var1);

        byte[] getBytes(long l) {
            long l2 = l * (long)this.ptrSize_;
            long l3 = this.readPointer(l2);
            long l4 = this.readPointer(l2 + (long)this.ptrSize_);
            int n = (int)Math.min(l4 - l3, Integer.MAX_VALUE);
            byte[] byArray = new byte[n];
            this.buf_.get(this.data0_ + l3, byArray);
            return byArray;
        }
    }

    private static abstract class LongReader
    extends AbstractReader<Long> {
        LongReader() {
            super(Long.class);
        }

        abstract long get(long var1);

        @Override
        public Long getObject(long l) {
            return this.get(l);
        }

        @Override
        public byte getByte(long l) {
            return (byte)this.get(l);
        }

        @Override
        public short getShort(long l) {
            return (short)this.get(l);
        }

        @Override
        public int getInt(long l) {
            return (int)this.get(l);
        }

        @Override
        public long getLong(long l) {
            return this.get(l);
        }

        @Override
        public float getFloat(long l) {
            return this.get(l);
        }

        @Override
        public double getDouble(long l) {
            return this.get(l);
        }
    }

    private static abstract class IntReader
    extends AbstractReader<Integer> {
        IntReader() {
            super(Integer.class);
        }

        abstract int get(long var1);

        @Override
        public Integer getObject(long l) {
            return this.get(l);
        }

        @Override
        public byte getByte(long l) {
            return (byte)this.get(l);
        }

        @Override
        public short getShort(long l) {
            return (short)this.get(l);
        }

        @Override
        public int getInt(long l) {
            return this.get(l);
        }

        @Override
        public long getLong(long l) {
            return this.get(l);
        }

        @Override
        public float getFloat(long l) {
            return this.get(l);
        }

        @Override
        public double getDouble(long l) {
            return this.get(l);
        }
    }

    private static abstract class ShortReader
    extends AbstractReader<Short> {
        ShortReader() {
            super(Short.class);
        }

        abstract short get(long var1);

        @Override
        public Short getObject(long l) {
            return this.get(l);
        }

        @Override
        public byte getByte(long l) {
            return (byte)this.get(l);
        }

        @Override
        public short getShort(long l) {
            return this.get(l);
        }

        @Override
        public int getInt(long l) {
            return this.get(l);
        }

        @Override
        public long getLong(long l) {
            return this.get(l);
        }

        @Override
        public float getFloat(long l) {
            return this.get(l);
        }

        @Override
        public double getDouble(long l) {
            return this.get(l);
        }
    }

    private static abstract class NonNumericReader<T>
    extends AbstractReader<T> {
        public NonNumericReader(Class<T> clazz) {
            super(clazz);
        }

        @Override
        public byte getByte(long l) {
            return 0;
        }

        @Override
        public short getShort(long l) {
            return 0;
        }

        @Override
        public int getInt(long l) {
            return 0;
        }

        @Override
        public long getLong(long l) {
            return 0L;
        }

        @Override
        public float getFloat(long l) {
            return Float.NaN;
        }

        @Override
        public double getDouble(long l) {
            return Double.NaN;
        }
    }

    private static abstract class AbstractReader<T>
    implements Reader<T> {
        final Class<T> clazz_;

        AbstractReader(Class<T> clazz) {
            this.clazz_ = clazz;
        }

        @Override
        public Class<T> getValueClass() {
            return this.clazz_;
        }

        @Override
        public boolean isNull(long l) {
            return false;
        }
    }
}

