/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.pdf.application;

import com.clusterra.freemarker.renderer.FreemarkerTemplateRenderer;
import com.clusterra.iam.avatar.application.AvatarService;
import com.clusterra.iam.core.application.tenant.TenantId;
import com.clusterra.iam.core.application.user.UserId;
import com.clusterra.iam.core.application.user.UserQueryService;
import com.clusterra.pmbok.document.application.document.DocumentQueryService;
import com.clusterra.pmbok.document.domain.model.document.Document;
import com.clusterra.pmbok.document.domain.model.document.DocumentId;
import com.clusterra.pmbok.document.domain.model.document.DocumentRevision;
import com.clusterra.pmbok.document.domain.model.document.section.SectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.SectionContentVisitor;
import com.clusterra.pmbok.document.domain.model.document.section.history.HistorySectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.reference.ReferenceSectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.term.TermSectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.text.TextSectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.title.TitleSectionContent;
import com.clusterra.pmbok.document.domain.model.document.section.toc.TocSectionContent;
import com.clusterra.pmbok.document.domain.model.history.HistoryEntry;
import com.clusterra.pmbok.document.domain.model.template.Template;
import com.clusterra.pmbok.pdf.application.DateTimeFormatters;
import com.clusterra.pmbok.pdf.application.DocumentToHtmlTransformer;
import com.clusterra.pmbok.pdf.section.HistoryData;
import com.clusterra.pmbok.template.Section;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class DocumentToHtmlTransformerImpl
implements DocumentToHtmlTransformer,
SectionContentVisitor<Section> {
    @Autowired
    private UserQueryService userQueryService;
    @Autowired
    private MessageSource messageSource;
    @Autowired
    private AvatarService avatarService;
    @Autowired
    private DocumentQueryService documentQueryService;
    @Autowired
    private FreemarkerTemplateRenderer freemarkerTemplateRenderer;

    @Override
    public String transform(TenantId tenantId, DocumentId documentId) throws Exception {
        ArrayList<Section> sections = new ArrayList<Section>();
        Document document = this.documentQueryService.findBy(documentId);
        Template template = document.getTemplate();
        List sectionContents = this.documentQueryService.findSectionContents(documentId);
        StringBuilder sectionsHtml = new StringBuilder();
        for (SectionContent section : sectionContents) {
            Section s = (Section)section.accept((SectionContentVisitor)this);
            if (s == null) continue;
            sections.add(s);
            sectionsHtml.append(s.getHtml());
        }
        StringBuilder partsHtml = new StringBuilder();
        DocumentRevision revision = this.documentQueryService.getRevision(documentId);
        partsHtml.append(this.getHeader(document.getModifiedDate(), revision.getRevision(), revision.getAvatarId(), revision.getDocumentName(), revision.getProjectName()));
        partsHtml.append(this.getFooter(revision.getProjectName()));
        String name = template.getName() + "_" + document.getRevision().toString();
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("documentTitle", name);
        vars.put("bookmarksHtml", "TODO bookmarks html");
        vars.put("partsHtml", partsHtml.toString());
        vars.put("sectionsHtml", sectionsHtml.toString());
        return this.freemarkerTemplateRenderer.render("layout.ftl", vars);
    }

    public Section visit(TitleSectionContent content) throws Exception {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("projectName", content.getProjectName());
        vars.put("docName", content.getRevision().getDocumentName());
        vars.put("docVersion", content.getRevision().getRevision());
        String render = this.freemarkerTemplateRenderer.render("part/title.ftl", vars);
        return new Section(render);
    }

    public Section visit(HistorySectionContent content) throws Exception {
        ArrayList<HistoryData> revisions = new ArrayList<HistoryData>();
        for (HistoryEntry update : content.getHistoryEntries()) {
            String createdByUserId = update.getCreatedByUserId();
            String author = createdByUserId == null ? "N/A" : this.userQueryService.findUser(new UserId(createdByUserId)).getPerson().getDisplayName();
            String createdDate = new DateTime((Object)update.getCreatedDate()).toString(DateTimeFormatters.LS);
            revisions.add(new HistoryData(createdDate, update.getRevision(), update.getComment(), author));
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("revisions", revisions);
        vars.put("sectionId", 1);
        vars.put("title", content.getSectionTemplate().getName());
        return new Section(this.freemarkerTemplateRenderer.render("section/revisionHistorySection.ftl", vars));
    }

    public Section visit(ReferenceSectionContent content) throws Exception {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("sectionId", content.getSectionTemplate().getSectionTemplateId().toString());
        vars.put("title", content.getSectionTemplate().getName());
        vars.put("references", content.getReferences());
        String render = this.freemarkerTemplateRenderer.render("section/normativeReferenceSection.ftl", vars);
        return new Section(render);
    }

    public Section visit(TermSectionContent content) throws Exception {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("sectionId", content.getSectionTemplate().getSectionTemplateId().toString());
        vars.put("title", content.getSectionTemplate().getName());
        vars.put("vocabulary", content.getTerms());
        String render = this.freemarkerTemplateRenderer.render("section/vocabularySection.ftl", vars);
        return new Section(render);
    }

    public Section visit(TextSectionContent content) throws Exception {
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("sectionId", content.getSectionTemplate().getSectionTemplateId().toString());
        vars.put("title", content.getSectionTemplate().getName());
        vars.put("text", content.getText());
        String render = this.freemarkerTemplateRenderer.render("section/textSection.ftl", vars);
        return new Section(render);
    }

    public Section visit(TocSectionContent content) throws Exception {
        HashMap<String, Object> vars = new HashMap<String, Object>();
        vars.put("title", content.getSectionTemplate().getName());
        vars.put("sections", content.getTocElements());
        String render = this.freemarkerTemplateRenderer.render("part/toc.ftl", vars);
        return new Section(render);
    }

    private String getHeader(Date modifiedDate, String documentRevision, String avatarId, String docName, String projectName) {
        String docUpdatedDateLabel = this.messageSource.getMessage("document.date.modified.label", null, "", LocaleContextHolder.getLocale());
        String docUpdatedDate = new DateTime((Object)modifiedDate).toString(DateTimeFormatters.LS);
        String docReferenceLabel = this.messageSource.getMessage("document.reference.label", null, "", LocaleContextHolder.getLocale());
        HashMap<String, String> vars = new HashMap<String, String>();
        vars.put("projectName", projectName);
        vars.put("docVersion", documentRevision);
        vars.put("docName", docName);
        String render = this.freemarkerTemplateRenderer.render("part/header.ftl", vars);
        return render;
    }

    private String getFooter(String projectName) {
        String footerLabel = this.messageSource.getMessage("document.footer.label", null, "", LocaleContextHolder.getLocale());
        String footerPageLabel = this.messageSource.getMessage("document.footer.page.label", null, "", LocaleContextHolder.getLocale());
        String footerPageOfLabel = this.messageSource.getMessage("document.footer.page.of.label", null, "", LocaleContextHolder.getLocale());
        HashMap vars = new HashMap();
        String render = this.freemarkerTemplateRenderer.render("part/footer.ftl", vars);
        return render;
    }
}

