/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.pdf.application;

import com.clusterra.iam.avatar.application.AvatarData;
import com.clusterra.iam.avatar.application.AvatarNotFoundException;
import com.clusterra.iam.avatar.application.AvatarService;
import com.clusterra.iam.core.application.tracker.IdentityTracker;
import com.clusterra.pmbok.document.application.document.DocumentQueryService;
import com.clusterra.pmbok.document.domain.model.document.Document;
import com.clusterra.pmbok.document.domain.model.document.DocumentId;
import com.clusterra.pmbok.document.domain.model.document.DocumentRevision;
import com.clusterra.pmbok.document.domain.service.document.DocumentDomainService;
import com.clusterra.pmbok.document.domain.service.document.DocumentNotFoundException;
import com.clusterra.pmbok.generate.pdf.PdfGeneratorService;
import com.clusterra.pmbok.pdf.application.DocumentPdfService;
import com.clusterra.pmbok.pdf.application.DocumentToHtmlTransformer;
import com.clusterra.pmbok.pdf.application.ResourceHelper;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class DocumentPdfServiceImpl
implements DocumentPdfService {
    @Autowired
    private DocumentDomainService documentDomainService;
    @Autowired
    private PdfGeneratorService pdfGeneratorService;
    @Autowired
    private DocumentToHtmlTransformer documentToHtmlTransformer;
    @Autowired
    private IdentityTracker identityTracker;
    @Autowired
    private AvatarService avatarService;
    @Autowired
    private DocumentQueryService documentQueryService;

    @Override
    @Transactional
    public byte[] generatePdf(DocumentId documentId) throws Exception {
        String html = this.documentToHtmlTransformer.transform(this.identityTracker.currentTenant(), documentId);
        HashMap<String, Resource> resources = new HashMap<String, Resource>();
        resources.put("main_pdf.css", (Resource)new ClassPathResource("css/main_pdf.css"));
        Map<String, byte[]> content = ResourceHelper.getContent(resources);
        DocumentRevision revision = this.documentQueryService.getRevision(documentId);
        content.putAll(this.getAvatar(revision.getAvatarId()));
        return this.pdfGeneratorService.generatePdfFromHtml(html, content);
    }

    @Override
    @Transactional
    public String getFileName(DocumentId documentId) throws DocumentNotFoundException {
        Document document = this.documentDomainService.findBy(documentId);
        return String.format("%s-%s.pdf", document.getTemplate().getName(), this.documentDomainService.getRevision(documentId).getRevision());
    }

    private Map<String, byte[]> getAvatar(String avatarId) {
        try {
            HashMap<String, byte[]> result = new HashMap<String, byte[]>(1);
            if (avatarId == null) {
                return result;
            }
            AvatarData avatarData = this.avatarService.find(avatarId);
            result.put("organization_avatar.png", avatarData.getImage128());
            return result;
        }
        catch (AvatarNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

