/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.generate.pdf;

import com.clusterra.pmbok.generate.pdf.ImageElementFactory;
import com.clusterra.pmbok.generate.pdf.PdfGeneratorService;
import com.clusterra.pmbok.generate.pdf.ResourceLoaderUserAgent;
import com.itextpdf.text.DocumentException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.SharedContext;
import org.xhtmlrenderer.pdf.ITextFontResolver;
import org.xhtmlrenderer.pdf.ITextRenderer;

@Service
public class PdfGeneratorServiceImpl
implements PdfGeneratorService {
    @Autowired
    private Resource defaultFontFile;

    @Override
    public byte[] generatePdfFromHtml(String html, Map<String, byte[]> resourceMap) {
        ITextRenderer renderer = new ITextRenderer();
        SharedContext sharedContext = renderer.getSharedContext();
        ITextFontResolver resolver = renderer.getFontResolver();
        try {
            resolver.addFont(this.defaultFontFile.getURI().toString(), "Identity-H", false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ResourceLoaderUserAgent callback = new ResourceLoaderUserAgent(renderer.getOutputDevice(), resourceMap);
        callback.setSharedContext(sharedContext);
        sharedContext.setUserAgentCallback((UserAgentCallback)callback);
        sharedContext.setReplacedElementFactory((ReplacedElementFactory)new ImageElementFactory(sharedContext.getReplacedElementFactory(), resourceMap));
        renderer.setDocumentFromString(html);
        renderer.layout();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            renderer.createPDF((OutputStream)out);
        }
        catch (DocumentException | IOException e) {
            throw new RuntimeException(e);
        }
        byte[] bytes = out.toByteArray();
        IOUtils.closeQuietly((OutputStream)out);
        return bytes;
    }
}

