/*
 * Decompiled with CFR 0.152.
 */
package com.clusterra.pmbok.generate.pdf;

import com.itextpdf.text.Image;
import java.io.File;
import java.util.Map;
import org.w3c.dom.Element;
import org.xhtmlrenderer.extend.FSImage;
import org.xhtmlrenderer.extend.ReplacedElement;
import org.xhtmlrenderer.extend.ReplacedElementFactory;
import org.xhtmlrenderer.extend.UserAgentCallback;
import org.xhtmlrenderer.layout.LayoutContext;
import org.xhtmlrenderer.pdf.ITextFSImage;
import org.xhtmlrenderer.pdf.ITextImageElement;
import org.xhtmlrenderer.render.BlockBox;
import org.xhtmlrenderer.simple.extend.FormSubmissionListener;

public class ImageElementFactory
implements ReplacedElementFactory {
    private final ReplacedElementFactory superFactory;
    private Map<String, byte[]> resourceMap;

    public ImageElementFactory(ReplacedElementFactory superFactory, Map<String, byte[]> resourceMap) {
        this.superFactory = superFactory;
        this.resourceMap = resourceMap;
    }

    public ReplacedElement createReplacedElement(LayoutContext layoutContext, BlockBox blockBox, UserAgentCallback userAgentCallback, int cssWidth, int cssHeight) {
        Element element = blockBox.getElement();
        if (element == null) {
            return null;
        }
        String nodeName = element.getNodeName();
        String src = element.getAttribute("src");
        String fileName = new File(src).getName();
        if ("img".equals(nodeName) && src != null && this.resourceMap.get(fileName) != null) {
            return ImageElementFactory.handleImageLink(element, this.resourceMap.get(fileName), cssWidth, cssHeight);
        }
        return this.superFactory.createReplacedElement(layoutContext, blockBox, userAgentCallback, cssWidth, cssHeight);
    }

    private static ReplacedElement handleImageLink(Element imageNode, byte[] imageContent, int cssWidth, int cssHeight) {
        try {
            Image image = Image.getInstance((byte[])imageContent);
            ITextFSImage fsImage = new ITextFSImage(image);
            if (cssWidth != -1 || cssHeight != -1) {
                fsImage.scale(cssWidth, cssHeight);
            }
            return new ITextImageElement((FSImage)fsImage);
        }
        catch (Exception e) {
            throw new RuntimeException("There was a problem trying to read an image content: " + imageNode.getAttribute("src"), e);
        }
    }

    public void reset() {
        this.superFactory.reset();
    }

    public void remove(Element e) {
        this.superFactory.remove(e);
    }

    public void setFormSubmissionListener(FormSubmissionListener listener) {
        this.superFactory.setFormSubmissionListener(listener);
    }
}

