/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.util;

import com.cloudinary.util.Base64Coder;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000L\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0004\u001a\u00020\u0005*\u00020\u0005H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0005H\u0000\u001a\f\u0010\b\u001a\u00020\t*\u00020\u0005H\u0000\u001a\f\u0010\n\u001a\u00020\u0007*\u00020\u0005H\u0000\u001a\u001e\u0010\u000b\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\f\u001a\u00020\u00052\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0000\u001a\f\u0010\u000f\u001a\u00020\u0005*\u00020\u0005H\u0000\u001a\f\u0010\u0010\u001a\u00020\u0005*\u00020\u0005H\u0000\u001a\u0018\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0012*\u00020\u0013H\u0000\u001a\u0012\u0010\u0014\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u0016\u001a\f\u0010\u0017\u001a\u00020\u0005*\u00020\u0005H\u0000\u001a\f\u0010\u0018\u001a\u00020\u0005*\u00020\u0005H\u0000\u001a\u0014\u0010\u0019\u001a\n \u001a*\u0004\u0018\u00010\u00050\u0005*\u00020\u0005H\u0000\u001a\u001e\u0010\u001b\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0000\u001a\n\u0010 \u001a\u00020\u0005*\u00020\t\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"HEX_ARRAY", "", "camelCaseRegex", "Lkotlin/text/Regex;", "cldEncodePublicId", "", "cldHasVersionString", "", "cldHexStringToByteArray", "", "cldIsHttpUrl", "cldJoinWithOrReturnOriginal", "separator", "toJoin", "", "cldMergeSlashedInUrl", "cldMergeToSingleUnderscore", "cldQueryAsMap", "", "Ljava/net/URI;", "cldRemoveStartingChars", "c", "", "cldSmartUrlEncode", "cldToBase64", "cldToUrlSafeBase64", "kotlin.jvm.PlatformType", "cldUrlEncode", "unsafe", "Ljava/util/regex/Pattern;", "charset", "Ljava/nio/charset/Charset;", "toHex", "url-builder"})
public final class StringUtilsKt {
    private static final char[] HEX_ARRAY;
    private static final Regex camelCaseRegex;

    @NotNull
    public static final String cldJoinWithOrReturnOriginal(@NotNull String $this$cldJoinWithOrReturnOriginal, @NotNull String separator, @Nullable Object toJoin) {
        Intrinsics.checkParameterIsNotNull((Object)$this$cldJoinWithOrReturnOriginal, (String)"$this$cldJoinWithOrReturnOriginal");
        Intrinsics.checkParameterIsNotNull((Object)separator, (String)"separator");
        return toJoin != null ? $this$cldJoinWithOrReturnOriginal + separator + toJoin.toString() : $this$cldJoinWithOrReturnOriginal;
    }

    public static final boolean cldIsHttpUrl(@NotNull String $this$cldIsHttpUrl) {
        Intrinsics.checkParameterIsNotNull((Object)$this$cldIsHttpUrl, (String)"$this$cldIsHttpUrl");
        return StringsKt.startsWith((String)$this$cldIsHttpUrl, (String)"https:/", (boolean)true) || StringsKt.startsWith((String)$this$cldIsHttpUrl, (String)"http:/", (boolean)true);
    }

    /*
     * WARNING - void declaration
     */
    public static final boolean cldHasVersionString(@NotNull String $this$cldHasVersionString) {
        Intrinsics.checkParameterIsNotNull((Object)$this$cldHasVersionString, (String)"$this$cldHasVersionString");
        boolean inVersion = false;
        int n = 0;
        int n2 = $this$cldHasVersionString.length();
        while (n < n2) {
            boolean bl;
            void i;
            char c = $this$cldHasVersionString.charAt((int)i);
            if (c == 'v') {
                bl = true;
            } else {
                if (Character.isDigit(c) && inVersion) {
                    return true;
                }
                bl = false;
            }
            inVersion = bl;
            ++i;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String cldMergeSlashedInUrl(@NotNull String $this$cldMergeSlashedInUrl) {
        Intrinsics.checkParameterIsNotNull((Object)$this$cldMergeSlashedInUrl, (String)"$this$cldMergeSlashedInUrl");
        StringBuilder builder = new StringBuilder();
        boolean prevIsColon = false;
        boolean inMerge = false;
        int n = 0;
        int n2 = $this$cldMergeSlashedInUrl.length();
        while (n < n2) {
            void i;
            char c = $this$cldMergeSlashedInUrl.charAt((int)i);
            if (c == ':') {
                prevIsColon = true;
                builder.append(c);
            } else {
                if (c == '/') {
                    boolean bl;
                    if (prevIsColon) {
                        builder.append(c);
                        bl = false;
                    } else {
                        if (!inMerge) {
                            builder.append(c);
                        }
                        bl = true;
                    }
                    inMerge = bl;
                } else {
                    inMerge = false;
                    builder.append(c);
                }
                prevIsColon = false;
            }
            ++i;
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String cldMergeToSingleUnderscore(@NotNull String $this$cldMergeToSingleUnderscore) {
        Intrinsics.checkParameterIsNotNull((Object)$this$cldMergeToSingleUnderscore, (String)"$this$cldMergeToSingleUnderscore");
        StringBuffer buffer = new StringBuffer();
        boolean inMerge = false;
        int n = 0;
        int n2 = $this$cldMergeToSingleUnderscore.length();
        while (n < n2) {
            void i;
            char c = $this$cldMergeToSingleUnderscore.charAt((int)i);
            if (c == ' ' || c == '_') {
                if (!inMerge) {
                    buffer.append('_');
                }
                inMerge = true;
            } else {
                inMerge = false;
                buffer.append(c);
            }
            ++i;
        }
        String string = buffer.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"buffer.toString()");
        return string;
    }

    @NotNull
    public static final String cldSmartUrlEncode(@NotNull String $this$cldSmartUrlEncode) {
        Intrinsics.checkParameterIsNotNull((Object)$this$cldSmartUrlEncode, (String)"$this$cldSmartUrlEncode");
        String string = URLEncoder.encode($this$cldSmartUrlEncode, "UTF-8");
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"URLEncoder.encode(this, \"UTF-8\")");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"%2F", (String)"/", (boolean)false, (int)4, null), (String)"%3A", (String)":", (boolean)false, (int)4, null), (String)"+", (String)"%20", (boolean)false, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Map<String, String> cldQueryAsMap(@NotNull URI $this$cldQueryAsMap) {
        Map map;
        Intrinsics.checkParameterIsNotNull((Object)$this$cldQueryAsMap, (String)"$this$cldQueryAsMap");
        Object object = $this$cldQueryAsMap.getQuery();
        if (object != null && (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])new String[]{"&"}, (boolean)false, (int)0, (int)6, null)) != null) {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = (Iterable)object;
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                String it = (String)element$iv$iv;
                boolean bl = false;
                List list = StringsKt.split$default((CharSequence)it, (String[])new String[]{"="}, (boolean)false, (int)0, (int)6, null);
                boolean bl2 = false;
                boolean bl3 = false;
                List $this$run = list;
                boolean bl4 = false;
                Pair pair = new Pair($this$run.get(0), $this$run.get(1));
                boolean bl5 = false;
                map2.put(pair.getFirst(), pair.getSecond());
            }
            map = destination$iv$iv;
        } else {
            map = MapsKt.emptyMap();
        }
        return map;
    }

    @NotNull
    public static final String cldToBase64(@NotNull String $this$cldToBase64) {
        Intrinsics.checkParameterIsNotNull((Object)$this$cldToBase64, (String)"$this$cldToBase64");
        String string = Base64Coder.encodeString($this$cldToBase64);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"encodeString(this)");
        return string;
    }

    public static final String cldToUrlSafeBase64(@NotNull String $this$cldToUrlSafeBase64) {
        Intrinsics.checkParameterIsNotNull((Object)$this$cldToUrlSafeBase64, (String)"$this$cldToUrlSafeBase64");
        return Base64Coder.encodeURLSafeString($this$cldToUrlSafeBase64);
    }

    @NotNull
    public static final String cldEncodePublicId(@NotNull String $this$cldEncodePublicId) {
        Intrinsics.checkParameterIsNotNull((Object)$this$cldEncodePublicId, (String)"$this$cldEncodePublicId");
        return StringsKt.replace$default((String)StringsKt.replace$default((String)$this$cldEncodePublicId, (char)'/', (char)':', (boolean)false, (int)4, null), (String)",", (String)"%2c", (boolean)false, (int)4, null);
    }

    @NotNull
    public static final String cldUrlEncode(@NotNull String $this$cldUrlEncode, @NotNull Pattern unsafe, @Nullable Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)$this$cldUrlEncode, (String)"$this$cldUrlEncode");
        Intrinsics.checkParameterIsNotNull((Object)unsafe, (String)"unsafe");
        StringBuffer sb = new StringBuffer($this$cldUrlEncode.length());
        Matcher matcher = unsafe.matcher($this$cldUrlEncode);
        while (matcher.find()) {
            String string;
            Locale locale;
            byte[] bytes;
            String string2;
            String str = matcher.group(0);
            Intrinsics.checkExpressionValueIsNotNull((Object)str, (String)"str");
            Charset charset2 = charset;
            if (charset2 == null) {
                Intrinsics.throwNpe();
            }
            Object object = charset2;
            int n = 0;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string3.getBytes((Charset)object), (String)"(this as java.lang.String).getBytes(charset)");
            StringBuilder escaped = new StringBuilder(str.length() * 3);
            for (byte aByte : bytes) {
                escaped.append('%');
                char ch = Character.forDigit(aByte >> 4 & 0xF, 16);
                escaped.append(ch);
                ch = Character.forDigit(aByte & 0xF, 16);
                escaped.append(ch);
            }
            String string4 = escaped.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"escaped.toString()");
            object = string4;
            Intrinsics.checkExpressionValueIsNotNull((Object)Locale.US, (String)"Locale.US");
            StringBuffer stringBuffer = sb;
            Matcher matcher2 = matcher;
            boolean bl = false;
            Object object2 = object;
            if (object2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)((String)object2).toLowerCase(locale), (String)"(this as java.lang.String).toLowerCase(locale)");
            matcher2.appendReplacement(stringBuffer, Matcher.quoteReplacement(string));
        }
        matcher.appendTail(sb);
        String string = sb.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sb.toString()");
        return string;
    }

    @NotNull
    public static final byte[] cldHexStringToByteArray(@NotNull String $this$cldHexStringToByteArray) {
        Intrinsics.checkParameterIsNotNull((Object)$this$cldHexStringToByteArray, (String)"$this$cldHexStringToByteArray");
        int len = $this$cldHexStringToByteArray.length();
        byte[] data = new byte[len / 2];
        boolean bl = len % 2 == 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Length of string to parse must be even.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit($this$cldHexStringToByteArray.charAt(i), 16) << 4) + Character.digit($this$cldHexStringToByteArray.charAt(i + 1), 16));
        }
        return data;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String toHex(@NotNull byte[] $this$toHex) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toHex, (String)"$this$toHex");
        char[] hexChars = new char[$this$toHex.length * 2];
        int n = 0;
        int n2 = $this$toHex.length;
        while (n < n2) {
            void j;
            int v = $this$toHex[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + true] = HEX_ARRAY[v & 0xF];
            ++j;
        }
        n = 0;
        return new String(hexChars);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final String cldRemoveStartingChars(@NotNull String $this$cldRemoveStartingChars, char c) {
        String string;
        Intrinsics.checkParameterIsNotNull((Object)$this$cldRemoveStartingChars, (String)"$this$cldRemoveStartingChars");
        int lastToRemove = -1;
        int n = 0;
        int n2 = ((CharSequence)$this$cldRemoveStartingChars).length();
        while (n < n2) {
            void i;
            if ($this$cldRemoveStartingChars.charAt((int)i) == c) {
                lastToRemove = i;
            } else if ($this$cldRemoveStartingChars.charAt((int)i) != c) break;
            ++i;
        }
        if (lastToRemove < 0) {
            string = $this$cldRemoveStartingChars;
        } else {
            String string2 = $this$cldRemoveStartingChars;
            n2 = lastToRemove + 1;
            boolean bl = false;
            String string3 = string2.substring(n2);
            string = string3;
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
        }
        return string;
    }

    static {
        String string = "0123456789abcdef";
        boolean bl = false;
        char[] cArray = string.toCharArray();
        Intrinsics.checkExpressionValueIsNotNull((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        HEX_ARRAY = cArray;
        camelCaseRegex = new Regex("[A-Z]");
    }
}

