/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.asset;

import com.cloudinary.AnalyticsKt;
import com.cloudinary.AuthTokenKt;
import com.cloudinary.asset.AssetKt;
import com.cloudinary.asset.FinalizedSource;
import com.cloudinary.config.CloudConfig;
import com.cloudinary.config.UrlConfig;
import com.cloudinary.transformation.CommonKt;
import com.cloudinary.transformation.Format;
import com.cloudinary.transformation.TransformationDsl;
import com.cloudinary.util.Base64Coder;
import com.cloudinary.util.StringUtilsKt;
import java.net.MalformedURLException;
import java.net.URL;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@TransformationDsl
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b'\u0018\u00002\u00020\u0001:\u0001\u000eB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\nJ\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0007J\n\u0010\r\u001a\u0004\u0018\u00010\u0007H&R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/cloudinary/asset/BaseAsset;", "", "cloudConfig", "Lcom/cloudinary/config/CloudConfig;", "urlConfig", "Lcom/cloudinary/config/UrlConfig;", "version", "", "publicId", "extension", "(Lcom/cloudinary/config/CloudConfig;Lcom/cloudinary/config/UrlConfig;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Object;)V", "generate", "source", "getTransformationString", "BaseAssetBuilder", "url-builder"})
public abstract class BaseAsset {
    private final CloudConfig cloudConfig;
    private final UrlConfig urlConfig;
    private final String version;
    private final String publicId;
    private final Object extension;

    @Nullable
    public final String generate(@Nullable String source) {
        CharSequence charSequence = this.cloudConfig.getCloudName();
        boolean bl = false;
        boolean bl2 = !StringsKt.isBlank((CharSequence)charSequence);
        bl = false;
        boolean bl3 = false;
        if (!bl2) {
            boolean bl4 = false;
            String string = "Must supply cloud_name in configuration";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        String string = source;
        if (string == null) {
            string = this.publicId;
        }
        if (string == null) {
            return null;
        }
        String mutableSource = string;
        boolean httpSource = StringUtilsKt.cldIsHttpUrl(mutableSource);
        String signature = "";
        FinalizedSource finalizedSource = AssetKt.access$finalizeSource(mutableSource, this.extension);
        mutableSource = finalizedSource.getSource();
        String sourceToSign = finalizedSource.getSourceToSign();
        String mutableVersion = this.version;
        if (this.urlConfig.getForceVersion() && StringsKt.contains$default((CharSequence)sourceToSign, (CharSequence)"/", (boolean)false, (int)2, null) && !StringUtilsKt.cldHasVersionString(sourceToSign) && !httpSource) {
            CharSequence charSequence2 = mutableVersion;
            boolean bl5 = false;
            boolean bl6 = false;
            if (charSequence2 == null || StringsKt.isBlank((CharSequence)charSequence2)) {
                mutableVersion = "1";
            }
        }
        mutableVersion = mutableVersion == null ? "" : 'v' + mutableVersion;
        String transformationString = this.getTransformationString();
        if (this.urlConfig.getSignUrl() && (this.cloudConfig.getAuthToken() == null || Intrinsics.areEqual((Object)this.cloudConfig.getAuthToken(), (Object)AuthTokenKt.getNULL_AUTH_TOKEN()))) {
            String signatureAlgorithm = this.urlConfig.getLongUrlSignature() ? "SHA-256" : this.urlConfig.getSignatureAlgorithm();
            String toSign = StringUtilsKt.cldMergeSlashedInUrl(StringUtilsKt.cldRemoveStartingChars(CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])new String[]{transformationString, sourceToSign}), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null), '/'));
            byte[] hash = AssetKt.access$hash(toSign + this.cloudConfig.getApiSecret(), signatureAlgorithm);
            String string2 = Base64Coder.encodeURLSafeString(hash);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"Base64Coder.encodeURLSafeString(hash)");
            signature = string2;
            String string3 = signature;
            int n = 0;
            int n2 = this.urlConfig.getLongUrlSignature() ? 32 : 8;
            StringBuilder stringBuilder = new StringBuilder().append("s--");
            boolean bl7 = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(n, n2);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String string6 = string5;
            signature = stringBuilder.append(string6).append("--").toString();
        }
        String prefix = AssetKt.access$unsignedDownloadUrlPrefix(this.cloudConfig.getCloudName(), this.urlConfig.getDomain());
        String url = StringUtilsKt.cldMergeSlashedInUrl(CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOfNotNull((Object[])new String[]{prefix, signature, transformationString, mutableVersion, mutableSource}), (CharSequence)"/", null, null, (int)0, null, null, (int)62, null));
        if (this.urlConfig.getSignUrl() && this.cloudConfig.getAuthToken() != null && Intrinsics.areEqual((Object)this.cloudConfig.getAuthToken(), (Object)AuthTokenKt.getNULL_AUTH_TOKEN()) ^ true) {
            String token = this.cloudConfig.getAuthToken().generate(new URL(url).getPath());
            return url + '?' + token;
        }
        try {
            URL urlObject = new URL(url);
            if (this.urlConfig.getAnalytics() && this.cloudConfig.getAuthToken() == null && urlObject.getQuery() == null) {
                String analytics = "_a=" + AnalyticsKt.generateAnalyticsSignature$default(null, null, 3, null);
                Object[] objectArray = new Object[]{analytics};
                String string7 = "?";
                return CommonKt.joinWithValues((Object)url, (Object[])objectArray, (String)string7);
            }
        }
        catch (MalformedURLException exception) {
            return url;
        }
        return url;
    }

    public static /* synthetic */ String generate$default(BaseAsset baseAsset, String string, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: generate");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        return baseAsset.generate(string);
    }

    @Nullable
    public abstract String getTransformationString();

    public BaseAsset(@NotNull CloudConfig cloudConfig, @NotNull UrlConfig urlConfig, @Nullable String version, @Nullable String publicId, @Nullable Object extension) {
        Intrinsics.checkParameterIsNotNull((Object)cloudConfig, (String)"cloudConfig");
        Intrinsics.checkParameterIsNotNull((Object)urlConfig, (String)"urlConfig");
        this.cloudConfig = cloudConfig;
        this.urlConfig = urlConfig;
        this.version = version;
        this.publicId = publicId;
        this.extension = extension;
    }

    public /* synthetic */ BaseAsset(CloudConfig cloudConfig, UrlConfig urlConfig, String string, String string2, Object object, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            string = null;
        }
        if ((n & 8) != 0) {
            string2 = null;
        }
        if ((n & 0x10) != 0) {
            object = null;
        }
        this(cloudConfig, urlConfig, string, string2, object);
    }

    @TransformationDsl
    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\b'\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0019J\u000e\u0010\t\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u000fJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0016\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u000fR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\u0001X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u000fX\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0011\"\u0004\b\u0018\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/cloudinary/asset/BaseAsset$BaseAssetBuilder;", "", "cloudConfig", "Lcom/cloudinary/config/CloudConfig;", "urlConfig", "Lcom/cloudinary/config/UrlConfig;", "(Lcom/cloudinary/config/CloudConfig;Lcom/cloudinary/config/UrlConfig;)V", "getCloudConfig", "()Lcom/cloudinary/config/CloudConfig;", "extension", "getExtension", "()Ljava/lang/Object;", "setExtension", "(Ljava/lang/Object;)V", "publicId", "", "getPublicId", "()Ljava/lang/String;", "setPublicId", "(Ljava/lang/String;)V", "getUrlConfig", "()Lcom/cloudinary/config/UrlConfig;", "version", "getVersion", "setVersion", "Lcom/cloudinary/transformation/Format;", "url-builder"})
    public static abstract class BaseAssetBuilder {
        @Nullable
        private String version;
        @Nullable
        private String publicId;
        @Nullable
        private Object extension;
        @NotNull
        private final CloudConfig cloudConfig;
        @NotNull
        private final UrlConfig urlConfig;

        @Nullable
        protected final String getVersion() {
            return this.version;
        }

        protected final void setVersion(@Nullable String string) {
            this.version = string;
        }

        @Nullable
        protected final String getPublicId() {
            return this.publicId;
        }

        protected final void setPublicId(@Nullable String string) {
            this.publicId = string;
        }

        @Nullable
        protected final Object getExtension() {
            return this.extension;
        }

        protected final void setExtension(@Nullable Object object) {
            this.extension = object;
        }

        @NotNull
        public final BaseAssetBuilder version(@NotNull String version) {
            Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
            BaseAssetBuilder baseAssetBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            BaseAssetBuilder $this$apply = baseAssetBuilder;
            boolean bl3 = false;
            $this$apply.version = version;
            return baseAssetBuilder;
        }

        @NotNull
        public final BaseAssetBuilder publicId(@NotNull String publicId) {
            Intrinsics.checkParameterIsNotNull((Object)publicId, (String)"publicId");
            BaseAssetBuilder baseAssetBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            BaseAssetBuilder $this$apply = baseAssetBuilder;
            boolean bl3 = false;
            $this$apply.publicId = publicId;
            return baseAssetBuilder;
        }

        @NotNull
        public final BaseAssetBuilder extension(@NotNull Format extension) {
            Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
            BaseAssetBuilder baseAssetBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            BaseAssetBuilder $this$apply = baseAssetBuilder;
            boolean bl3 = false;
            $this$apply.extension = extension;
            return baseAssetBuilder;
        }

        @NotNull
        public final BaseAssetBuilder extension(@NotNull String extension) {
            Intrinsics.checkParameterIsNotNull((Object)extension, (String)"extension");
            BaseAssetBuilder baseAssetBuilder = this;
            boolean bl = false;
            boolean bl2 = false;
            BaseAssetBuilder $this$apply = baseAssetBuilder;
            boolean bl3 = false;
            $this$apply.extension = extension;
            return baseAssetBuilder;
        }

        @NotNull
        protected final CloudConfig getCloudConfig() {
            return this.cloudConfig;
        }

        @NotNull
        protected final UrlConfig getUrlConfig() {
            return this.urlConfig;
        }

        public BaseAssetBuilder(@NotNull CloudConfig cloudConfig, @NotNull UrlConfig urlConfig) {
            Intrinsics.checkParameterIsNotNull((Object)cloudConfig, (String)"cloudConfig");
            Intrinsics.checkParameterIsNotNull((Object)urlConfig, (String)"urlConfig");
            this.cloudConfig = cloudConfig;
            this.urlConfig = urlConfig;
        }
    }
}

