/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary.asset;

import com.cloudinary.asset.FinalizedSource;
import com.cloudinary.util.StringUtilsKt;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0006\u001a\u001e\u0010\b\u001a\u0004\u0018\u00010\u00012\b\u0010\t\u001a\u0004\u0018\u00010\u00012\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0002\u001a\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00012\u0006\u0010\u0013\u001a\u00020\u0001H\u0002\u001a\u001c\u0010\u0014\u001a\u00020\u00012\b\u0010\u0015\u001a\u0004\u0018\u00010\u00012\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0080T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"AKAMAI_SHARED_CDN", "", "ASSET_TYPE_IMAGE", "ASSET_TYPE_VIDEO", "DEFAULT_ASSET_TYPE", "DEFAULT_DELIVERY_TYPE", "OLD_AKAMAI_SHARED_CDN", "SHARED_CDN", "finalizeResourceType", "resourceType", "urlSuffix", "finalizeSource", "Lcom/cloudinary/asset/FinalizedSource;", "source", "extension", "", "hash", "", "input", "signatureAlgorithm", "unsignedDownloadUrlPrefix", "cloudName", "domain", "url-builder"})
public final class AssetKt {
    private static final String OLD_AKAMAI_SHARED_CDN = "cloudinary-a.akamaihd.net";
    private static final String AKAMAI_SHARED_CDN = "media.cloudinary.net";
    private static final String SHARED_CDN = "media.cloudinary.net";
    @NotNull
    public static final String DEFAULT_ASSET_TYPE = "image";
    @NotNull
    public static final String DEFAULT_DELIVERY_TYPE = "upload";
    @NotNull
    public static final String ASSET_TYPE_IMAGE = "image";
    @NotNull
    public static final String ASSET_TYPE_VIDEO = "video";

    private static final FinalizedSource finalizeSource(String source, Object extension) {
        String mutableSource = StringUtilsKt.cldMergeSlashedInUrl(source);
        String sourceToSign = null;
        if (StringUtilsKt.cldIsHttpUrl(mutableSource)) {
            sourceToSign = mutableSource = StringUtilsKt.cldSmartUrlEncode(mutableSource);
        } else {
            String string;
            try {
                String string2 = URLDecoder.decode(StringsKt.replace$default((String)mutableSource, (String)"+", (String)"%2B", (boolean)false, (int)4, null), "UTF-8");
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"URLDecoder.decode(mutabl\u2026ace(\"+\", \"%2B\"), \"UTF-8\")");
                string = StringUtilsKt.cldSmartUrlEncode(string2);
            }
            catch (UnsupportedEncodingException e) {
                throw (Throwable)new RuntimeException(e);
            }
            sourceToSign = mutableSource = string;
            if (extension != null) {
                mutableSource = mutableSource + '.' + extension;
                sourceToSign = sourceToSign + '.' + extension;
            }
        }
        return new FinalizedSource(mutableSource, sourceToSign);
    }

    private static final String finalizeResourceType(String resourceType, String urlSuffix) {
        String string = resourceType;
        if (string == null) {
            string = "image";
        }
        String mutableResourceType = string;
        String mutableType = DEFAULT_DELIVERY_TYPE;
        CharSequence charSequence = urlSuffix;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            if (Intrinsics.areEqual((Object)mutableResourceType, (Object)"image") && Intrinsics.areEqual((Object)mutableType, (Object)DEFAULT_DELIVERY_TYPE)) {
                mutableResourceType = "images";
                mutableType = null;
            } else if (Intrinsics.areEqual((Object)mutableResourceType, (Object)"image") && Intrinsics.areEqual((Object)mutableType, (Object)"private")) {
                mutableResourceType = "private_images";
                mutableType = null;
            } else if (Intrinsics.areEqual((Object)mutableResourceType, (Object)"image") && Intrinsics.areEqual((Object)mutableType, (Object)"authenticated")) {
                mutableResourceType = "authenticated_images";
                mutableType = null;
            } else if (Intrinsics.areEqual((Object)mutableResourceType, (Object)"raw") && Intrinsics.areEqual((Object)mutableType, (Object)DEFAULT_DELIVERY_TYPE)) {
                mutableResourceType = "files";
                mutableType = null;
            } else if (Intrinsics.areEqual((Object)mutableResourceType, (Object)ASSET_TYPE_VIDEO) && Intrinsics.areEqual((Object)mutableType, (Object)DEFAULT_DELIVERY_TYPE)) {
                mutableResourceType = "videos";
                mutableType = null;
            } else {
                throw (Throwable)new IllegalArgumentException("URL Suffix only supported for image/upload, image/private, raw/upload, image/authenticated  and video/upload");
            }
        }
        String result = mutableResourceType;
        if (mutableType != null) {
            result = Intrinsics.stringPlus((String)result, (Object)('/' + mutableType));
        }
        return result;
    }

    private static final String unsignedDownloadUrlPrefix(String cloudName, String domain) {
        String mutableCloudName = cloudName;
        String mutableSecureDistribution = domain;
        String string = mutableCloudName;
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            boolean bl2 = false;
            String it = string2;
            boolean bl3 = false;
            if (StringsKt.startsWith$default((String)it, (String)"/", (boolean)false, (int)2, null)) {
                return "/res" + mutableCloudName;
            }
        }
        boolean sharedDomain = true;
        String prefix = null;
        CharSequence charSequence = mutableSecureDistribution;
        boolean bl = false;
        boolean bl4 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || Intrinsics.areEqual((Object)mutableSecureDistribution, (Object)OLD_AKAMAI_SHARED_CDN)) {
            mutableSecureDistribution = cloudName + ".media.cloudinary.net";
        }
        prefix = "https://" + mutableSecureDistribution;
        return prefix;
    }

    private static final byte[] hash(String input, String signatureAlgorithm) {
        Object object;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(signatureAlgorithm);
            object = input;
            Charset charset = Charset.forName("UTF-8");
            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"Charset.forName(\"UTF-8\")");
            Charset charset2 = charset;
            MessageDigest messageDigest2 = messageDigest;
            boolean bl = false;
            String string = object;
            if (string == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string.getBytes(charset2);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] byArray2 = byArray;
            object = messageDigest2.digest(byArray2);
        }
        catch (NoSuchAlgorithmException e) {
            throw (Throwable)new RuntimeException("Unexpected exception", e);
        }
        return object;
    }

    public static final /* synthetic */ FinalizedSource access$finalizeSource(String source, Object extension) {
        return AssetKt.finalizeSource(source, extension);
    }

    public static final /* synthetic */ byte[] access$hash(String input, String signatureAlgorithm) {
        return AssetKt.hash(input, signatureAlgorithm);
    }

    public static final /* synthetic */ String access$unsignedDownloadUrlPrefix(String cloudName, String domain) {
        return AssetKt.unsignedDownloadUrlPrefix(cloudName, domain);
    }
}

