/*
 * Decompiled with CFR 0.152.
 */
package com.cloudinary;

import com.cloudinary.AuthTokenKt;
import com.cloudinary.util.StringUtilsKt;
import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0017\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u000e\u0010\u0002\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004BY\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u0006\u0012\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\r\u001a\u00020\t\u0012\b\b\u0002\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\u0006H\u00c2\u0003J\t\u0010\u0017\u001a\u00020\u0006H\u00c2\u0003J\t\u0010\u0018\u001a\u00020\tH\u00c6\u0003J\t\u0010\u0019\u001a\u00020\tH\u00c2\u0003J\u000b\u0010\u001a\u001a\u0004\u0018\u00010\u0006H\u00c2\u0003J\u000b\u0010\u001b\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u000fH\u00c2\u0003J_\u0010\u001e\u001a\u00020\u00002\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\f\u001a\u0004\u0018\u00010\u00062\b\b\u0002\u0010\r\u001a\u00020\t2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u00c6\u0001J\u0010\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u0006H\u0002J\u0013\u0010!\u001a\u00020\u000f2\b\u0010\"\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0010\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u0006H\u0002J\u0012\u0010%\u001a\u00020\u00062\n\b\u0002\u0010$\u001a\u0004\u0018\u00010\u0006J\b\u0010&\u001a\u00020'H\u0016J\t\u0010(\u001a\u00020\u0006H\u00d6\u0001R\u0013\u0010\f\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\r\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0014R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/cloudinary/AuthToken;", "", "params", "", "(Ljava/util/Map;)V", "tokenName", "", "key", "startTime", "", "expiration", "ip", "acl", "duration", "isNullToken", "", "(Ljava/lang/String;Ljava/lang/String;JJLjava/lang/String;Ljava/lang/String;JZ)V", "getAcl", "()Ljava/lang/String;", "getDuration", "()J", "getStartTime", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "copy", "digest", "message", "equals", "other", "escapeToLower", "url", "generate", "hashCode", "", "toString", "url-builder"})
public final class AuthToken {
    private final String tokenName;
    private final String key;
    private final long startTime;
    private final long expiration;
    private final String ip;
    @Nullable
    private final String acl;
    private final long duration;
    private final boolean isNullToken;

    @NotNull
    public final String generate(@Nullable String url) {
        long expiration = this.expiration;
        if (expiration == 0L) {
            long l;
            if (this.duration > 0L) {
                if (this.startTime > 0L) {
                    l = this.startTime;
                } else {
                    Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
                    Intrinsics.checkExpressionValueIsNotNull((Object)calendar, (String)"Calendar.getInstance(TimeZone.getTimeZone(\"UTC\"))");
                    l = calendar.getTimeInMillis() / 1000L;
                }
            } else {
                throw (Throwable)new IllegalArgumentException("Must provide either expiration or duration");
            }
            long start = l;
            expiration = start + this.duration;
        }
        ArrayList<String> tokenParts = new ArrayList<String>();
        if (this.ip != null) {
            tokenParts.add("ip=" + this.ip);
        }
        if (this.startTime > 0L) {
            tokenParts.add("st=" + this.startTime);
        }
        tokenParts.add("exp=" + expiration);
        if (this.acl != null) {
            tokenParts.add("acl=" + this.escapeToLower(this.acl));
        }
        ArrayList<String> toSign = new ArrayList<String>((Collection)tokenParts);
        if (url != null && this.acl == null) {
            toSign.add("url=" + this.escapeToLower(url));
        }
        String auth = this.digest(CollectionsKt.joinToString$default((Iterable)toSign, (CharSequence)"~", null, null, (int)0, null, null, (int)62, null));
        tokenParts.add("hmac=" + auth);
        return this.tokenName + "=" + CollectionsKt.joinToString$default((Iterable)tokenParts, (CharSequence)"~", null, null, (int)0, null, null, (int)62, null);
    }

    public static /* synthetic */ String generate$default(AuthToken authToken, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return authToken.generate(string);
    }

    private final String escapeToLower(String url) {
        return StringUtilsKt.cldUrlEncode(url, AuthTokenKt.access$getUNSAFE_URL_CHARS_PATTERN$p(), Charset.forName("UTF-8"));
    }

    private final String digest(String message) {
        String string;
        byte[] binKey = StringUtilsKt.cldHexStringToByteArray(this.key);
        try {
            Mac hmac = Mac.getInstance("HmacSHA256");
            SecretKeySpec secret = new SecretKeySpec(binKey, "HmacSHA256");
            hmac.init(secret);
            String string2 = message;
            Object object = Charsets.UTF_8;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            byte[] byArray = string3.getBytes((Charset)object);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
            byte[] bytes = byArray;
            byte[] byArray2 = hmac.doFinal(bytes);
            Intrinsics.checkExpressionValueIsNotNull((Object)byArray2, (String)"hmac.doFinal(bytes)");
            string2 = StringUtilsKt.toHex(byArray2);
            Locale locale = Locale.US;
            Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"Locale.US");
            object = locale;
            bl = false;
            String string4 = string2;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.toLowerCase((Locale)object);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).toLowerCase(locale)");
            string = string5;
        }
        catch (NoSuchAlgorithmException e) {
            throw (Throwable)new RuntimeException("Cannot create authorization token.", e);
        }
        catch (InvalidKeyException e) {
            throw (Throwable)new RuntimeException("Cannot create authorization token.", e);
        }
        return string;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AuthToken)) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.tokenName, (Object)((AuthToken)other).tokenName) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.key, (Object)((AuthToken)other).key) ^ true) {
            return false;
        }
        if (this.startTime != ((AuthToken)other).startTime) {
            return false;
        }
        if (this.expiration != ((AuthToken)other).expiration) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.ip, (Object)((AuthToken)other).ip) ^ true) {
            return false;
        }
        if (Intrinsics.areEqual((Object)this.acl, (Object)((AuthToken)other).acl) ^ true) {
            return false;
        }
        if (this.duration != ((AuthToken)other).duration) {
            return false;
        }
        return this.isNullToken == ((AuthToken)other).isNullToken;
    }

    public int hashCode() {
        if (this.isNullToken) {
            return 0;
        }
        String string = this.tokenName;
        int result = string != null ? string.hashCode() : 0;
        result = 31 * result + this.key.hashCode();
        result = 31 * result + ((Object)this.startTime).hashCode();
        result = 31 * result + ((Object)this.expiration).hashCode();
        String string2 = this.ip;
        result = 31 * result + (string2 != null ? string2.hashCode() : 0);
        String string3 = this.acl;
        result = 31 * result + (string3 != null ? string3.hashCode() : 0);
        result = 31 * result + ((Object)this.duration).hashCode();
        return result;
    }

    public final long getStartTime() {
        return this.startTime;
    }

    @Nullable
    public final String getAcl() {
        return this.acl;
    }

    public final long getDuration() {
        return this.duration;
    }

    public AuthToken(@Nullable String tokenName, @NotNull String key, long startTime, long expiration, @Nullable String ip, @Nullable String acl, long duration, boolean isNullToken) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        this.tokenName = tokenName;
        this.key = key;
        this.startTime = startTime;
        this.expiration = expiration;
        this.ip = ip;
        this.acl = acl;
        this.duration = duration;
        this.isNullToken = isNullToken;
    }

    public /* synthetic */ AuthToken(String string, String string2, long l, long l2, String string3, String string4, long l3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "__cld_token__";
        }
        if ((n & 4) != 0) {
            l = 0L;
        }
        if ((n & 8) != 0) {
            l2 = 0L;
        }
        if ((n & 0x10) != 0) {
            string3 = null;
        }
        if ((n & 0x20) != 0) {
            string4 = null;
        }
        if ((n & 0x40) != 0) {
            l3 = 0L;
        }
        if ((n & 0x80) != 0) {
            bl = false;
        }
        this(string, string2, l, l2, string3, string4, l3, bl);
    }

    public AuthToken(@NotNull Map<?, ?> params) {
        long l;
        Object object;
        Object object2;
        long l2;
        long l3;
        Intrinsics.checkParameterIsNotNull(params, (String)"params");
        Object object3 = params;
        String string = "key";
        String string2 = null;
        AuthToken authToken = this;
        boolean bl = false;
        Object object4 = object3.get(string);
        AuthToken authToken2 = authToken;
        String string3 = string2;
        Object obj = object4;
        if (obj == null) {
            object3 = "Must provide Auth Token key";
            string2 = string3;
            authToken = authToken2;
            boolean bl2 = false;
            throw (Throwable)new IllegalStateException(object3.toString());
        }
        object3 = params;
        string = "start_time";
        object4 = obj.toString();
        string2 = string3;
        authToken = authToken2;
        bl = false;
        Object obj2 = object3.get(string);
        AuthToken authToken3 = authToken;
        String string4 = string2;
        Object object5 = object4;
        Object obj3 = obj2;
        if (obj3 != null && (obj3 = obj3.toString()) != null) {
            object3 = obj3;
            object4 = object5;
            string2 = string4;
            authToken = authToken3;
            boolean bl3 = false;
            long l4 = Long.parseLong(object3);
            authToken3 = authToken;
            string4 = string2;
            object5 = object4;
            l3 = l4;
        } else {
            l3 = 0L;
        }
        object3 = params;
        String string5 = "expiration";
        long l5 = l3;
        object4 = object5;
        string2 = string4;
        authToken = authToken3;
        bl = false;
        Object obj4 = object3.get(string5);
        AuthToken authToken4 = authToken;
        String string6 = string2;
        Object object6 = object4;
        long l6 = l5;
        Object obj5 = obj4;
        if (obj5 != null && (obj5 = obj5.toString()) != null) {
            object3 = obj5;
            l5 = l6;
            object4 = object6;
            string2 = string6;
            authToken = authToken4;
            boolean bl4 = false;
            long l7 = Long.parseLong(object3);
            authToken4 = authToken;
            string6 = string2;
            object6 = object4;
            l6 = l5;
            l2 = l7;
        } else {
            l2 = 0L;
        }
        object3 = params;
        String string7 = "ip";
        long l8 = l2;
        l5 = l6;
        object4 = object6;
        string2 = string6;
        authToken = authToken4;
        bl = false;
        Object obj6 = object2 = object3.get(string7);
        object3 = params;
        string7 = "acl";
        object2 = obj6 != null ? obj6.toString() : null;
        bl = false;
        Object obj7 = object = object3.get(string7);
        object3 = params;
        string7 = "duration";
        object = obj7 != null ? obj7.toString() : null;
        bl = false;
        Object obj8 = object3.get(string7);
        AuthToken authToken5 = authToken;
        String string8 = string2;
        Object object7 = object4;
        long l9 = l5;
        long l10 = l8;
        Object object8 = object2;
        Object object9 = object;
        Object obj9 = obj8;
        if (obj9 != null && (obj9 = obj9.toString()) != null) {
            object3 = obj9;
            object = object9;
            object2 = object8;
            l8 = l10;
            l5 = l9;
            object4 = object7;
            string2 = string8;
            authToken = authToken5;
            boolean bl5 = false;
            long l11 = Long.parseLong((String)object3);
            authToken5 = authToken;
            string8 = string2;
            object7 = object4;
            l9 = l5;
            l10 = l8;
            object8 = object2;
            object9 = object;
            l = l11;
        } else {
            l = 0L;
        }
        authToken5(string8, (String)object7, l9, l10, (String)object8, (String)object9, l, false, 129, null);
    }

    private final String component1() {
        return this.tokenName;
    }

    private final String component2() {
        return this.key;
    }

    public final long component3() {
        return this.startTime;
    }

    private final long component4() {
        return this.expiration;
    }

    private final String component5() {
        return this.ip;
    }

    @Nullable
    public final String component6() {
        return this.acl;
    }

    public final long component7() {
        return this.duration;
    }

    private final boolean component8() {
        return this.isNullToken;
    }

    @NotNull
    public final AuthToken copy(@Nullable String tokenName, @NotNull String key, long startTime, long expiration, @Nullable String ip, @Nullable String acl, long duration, boolean isNullToken) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return new AuthToken(tokenName, key, startTime, expiration, ip, acl, duration, isNullToken);
    }

    public static /* synthetic */ AuthToken copy$default(AuthToken authToken, String string, String string2, long l, long l2, String string3, String string4, long l3, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = authToken.tokenName;
        }
        if ((n & 2) != 0) {
            string2 = authToken.key;
        }
        if ((n & 4) != 0) {
            l = authToken.startTime;
        }
        if ((n & 8) != 0) {
            l2 = authToken.expiration;
        }
        if ((n & 0x10) != 0) {
            string3 = authToken.ip;
        }
        if ((n & 0x20) != 0) {
            string4 = authToken.acl;
        }
        if ((n & 0x40) != 0) {
            l3 = authToken.duration;
        }
        if ((n & 0x80) != 0) {
            bl = authToken.isNullToken;
        }
        return authToken.copy(string, string2, l, l2, string3, string4, l3, bl);
    }

    @NotNull
    public String toString() {
        return "AuthToken(tokenName=" + this.tokenName + ", key=" + this.key + ", startTime=" + this.startTime + ", expiration=" + this.expiration + ", ip=" + this.ip + ", acl=" + this.acl + ", duration=" + this.duration + ", isNullToken=" + this.isNullToken + ")";
    }
}

