/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.resource.async;

import com.cloudconvert.client.mapper.ObjectMapperProvider;
import com.cloudconvert.client.setttings.SettingsProvider;
import com.cloudconvert.dto.request.WebhookRequest;
import com.cloudconvert.dto.response.Pageable;
import com.cloudconvert.dto.response.WebhookResponse;
import com.cloudconvert.dto.result.AsyncResult;
import com.cloudconvert.executor.AsyncRequestExecutor;
import com.cloudconvert.resource.AbstractWebhooksResource;
import com.cloudconvert.resource.params.Filter;
import com.cloudconvert.resource.params.Pagination;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AsyncWebhookResource
extends AbstractWebhooksResource<AsyncResult<WebhookResponse>, AsyncResult<Pageable<WebhookResponse>>, AsyncResult<Void>> {
    private final AsyncRequestExecutor asyncRequestExecutor;

    public AsyncWebhookResource(SettingsProvider settingsProvider, ObjectMapperProvider objectMapperProvider, AsyncRequestExecutor asyncRequestExecutor) {
        super(settingsProvider, objectMapperProvider);
        this.asyncRequestExecutor = asyncRequestExecutor;
    }

    @Override
    public AsyncResult<WebhookResponse> create(@NotNull WebhookRequest webhookRequest) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getCreateHttpUriRequest(webhookRequest), WEBHOOKS_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public AsyncResult<Pageable<WebhookResponse>> list() throws IOException, URISyntaxException {
        return this.list((Map)ImmutableMap.of());
    }

    @Override
    public AsyncResult<Pageable<WebhookResponse>> list(@NotNull Map<Filter, String> filters) throws IOException, URISyntaxException {
        return this.list((Map)filters, (Pagination)null);
    }

    @Override
    public AsyncResult<Pageable<WebhookResponse>> list(@NotNull Map<Filter, String> filters, @Nullable Pagination pagination) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getListHttpUriRequest(filters, pagination), WEBHOOKS_RESPONSE_PAGEABLE_TYPE_REFERENCE);
    }

    @Override
    public AsyncResult<Void> delete(@NotNull String webhookId) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getDeleteHttpUriRequest(webhookId), VOID_TYPE_REFERENCE);
    }

    @Override
    public void close() throws IOException {
        this.asyncRequestExecutor.close();
    }
}

