/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.resource.sync;

import com.cloudconvert.client.mapper.ObjectMapperProvider;
import com.cloudconvert.client.setttings.SettingsProvider;
import com.cloudconvert.dto.request.TaskRequest;
import com.cloudconvert.dto.response.JobResponse;
import com.cloudconvert.dto.response.Pageable;
import com.cloudconvert.dto.result.Result;
import com.cloudconvert.executor.RequestExecutor;
import com.cloudconvert.resource.AbstractJobsResource;
import com.cloudconvert.resource.params.Filter;
import com.cloudconvert.resource.params.Include;
import com.cloudconvert.resource.params.Pagination;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobsResource
extends AbstractJobsResource<Result<JobResponse>, Result<Pageable<JobResponse>>, Result<Void>> {
    private static final Logger log = LoggerFactory.getLogger(JobsResource.class);
    private final RequestExecutor requestExecutor;

    public JobsResource(SettingsProvider settingsProvider, ObjectMapperProvider objectMapperProvider, RequestExecutor requestExecutor) {
        super(settingsProvider, objectMapperProvider);
        this.requestExecutor = requestExecutor;
    }

    @Override
    public Result<JobResponse> create(@NotNull Map<String, TaskRequest> tasks) throws IOException, URISyntaxException {
        return this.create((Map)tasks, "");
    }

    @Override
    public Result<JobResponse> create(@NotNull Map<String, TaskRequest> tasks, @NotNull String tag) throws IOException, URISyntaxException {
        return this.requestExecutor.execute(this.getCreateHttpUriRequest(tasks, tag), JOB_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public Result<JobResponse> show(@NotNull String jobId) throws IOException, URISyntaxException {
        return this.requestExecutor.execute(this.getShowHttpUriRequest(jobId), JOB_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public Result<JobResponse> wait(@NotNull String jobId) throws IOException, URISyntaxException {
        return this.requestExecutor.execute(this.getWaitHttpUriRequest(jobId), JOB_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public Result<Pageable<JobResponse>> list() throws IOException, URISyntaxException {
        return this.list((Map)ImmutableMap.of());
    }

    @Override
    public Result<Pageable<JobResponse>> list(@NotNull Map<Filter, String> filters) throws IOException, URISyntaxException {
        return this.list((Map)filters, (List)ImmutableList.of());
    }

    @Override
    public Result<Pageable<JobResponse>> list(@NotNull Map<Filter, String> filters, @NotNull List<Include> includes) throws IOException, URISyntaxException {
        return this.list((Map)filters, (List)includes, (Pagination)null);
    }

    @Override
    public Result<Pageable<JobResponse>> list(@NotNull Map<Filter, String> filters, @NotNull List<Include> includes, @Nullable Pagination pagination) throws IOException, URISyntaxException {
        return this.requestExecutor.execute(this.getListHttpUriRequest(filters, includes, pagination), JOB_RESPONSE_PAGEABLE_TYPE_REFERENCE);
    }

    @Override
    public Result<Void> delete(@NotNull String jobId) throws IOException, URISyntaxException {
        return this.requestExecutor.execute(this.getDeleteHttpUriRequest(jobId), VOID_TYPE_REFERENCE);
    }

    @Override
    public void close() throws IOException {
        this.requestExecutor.close();
    }
}

