/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.resource.async;

import com.cloudconvert.client.mapper.ObjectMapperProvider;
import com.cloudconvert.client.setttings.SettingsProvider;
import com.cloudconvert.dto.request.CaptureWebsitesTaskRequest;
import com.cloudconvert.dto.request.ConvertFilesTaskRequest;
import com.cloudconvert.dto.request.CreateArchivesTaskRequest;
import com.cloudconvert.dto.request.CreateThumbnailsTaskRequest;
import com.cloudconvert.dto.request.ExecuteCommandsTaskRequest;
import com.cloudconvert.dto.request.GetMetadataTaskRequest;
import com.cloudconvert.dto.request.MergeFilesTaskRequest;
import com.cloudconvert.dto.request.OptimizeFilesTaskRequest;
import com.cloudconvert.dto.response.OperationResponse;
import com.cloudconvert.dto.response.Pageable;
import com.cloudconvert.dto.response.TaskResponse;
import com.cloudconvert.dto.result.AsyncResult;
import com.cloudconvert.executor.AsyncRequestExecutor;
import com.cloudconvert.resource.AbstractTasksResource;
import com.cloudconvert.resource.async.AsyncCaptureWebsitesResource;
import com.cloudconvert.resource.async.AsyncConvertFilesResource;
import com.cloudconvert.resource.async.AsyncCreateArchivesResource;
import com.cloudconvert.resource.async.AsyncCreateThumbnailsResource;
import com.cloudconvert.resource.async.AsyncExecuteCommandsResource;
import com.cloudconvert.resource.async.AsyncGetMetadataResource;
import com.cloudconvert.resource.async.AsyncMergeFilesResource;
import com.cloudconvert.resource.async.AsyncOptimizeFilesResource;
import com.cloudconvert.resource.params.Filter;
import com.cloudconvert.resource.params.Include;
import com.cloudconvert.resource.params.Pagination;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncTasksResource
extends AbstractTasksResource<AsyncResult<TaskResponse>, AsyncResult<Pageable<TaskResponse>>, AsyncResult<Void>, AsyncResult<Pageable<OperationResponse>>> {
    private static final Logger log = LoggerFactory.getLogger(AsyncTasksResource.class);
    private final AsyncRequestExecutor asyncRequestExecutor;

    public AsyncTasksResource(SettingsProvider settingsProvider, ObjectMapperProvider objectMapperProvider, AsyncRequestExecutor asyncRequestExecutor, AsyncConvertFilesResource asyncConvertFilesResource, AsyncOptimizeFilesResource asyncOptimizeFilesResource, AsyncCaptureWebsitesResource asyncCaptureWebsitesResource, AsyncMergeFilesResource asyncMergeFilesResource, AsyncCreateArchivesResource asyncCreateArchivesResource, AsyncExecuteCommandsResource asyncExecuteCommandsResource, AsyncCreateThumbnailsResource asyncCreateThumbnailsResource, AsyncGetMetadataResource asyncGetMetadataResource) {
        super(settingsProvider, objectMapperProvider, asyncConvertFilesResource, asyncOptimizeFilesResource, asyncCaptureWebsitesResource, asyncMergeFilesResource, asyncCreateArchivesResource, asyncExecuteCommandsResource, asyncCreateThumbnailsResource, asyncGetMetadataResource);
        this.asyncRequestExecutor = asyncRequestExecutor;
    }

    @Override
    public AsyncResult<TaskResponse> show(@NotNull String taskId) throws IOException, URISyntaxException {
        return this.show(taskId, (List)ImmutableList.of());
    }

    @Override
    public AsyncResult<TaskResponse> show(@NotNull String taskId, @NotNull List<Include> includes) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getShowHttpUriRequest(taskId, includes), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public AsyncResult<TaskResponse> wait(@NotNull String taskId) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getWaitHttpUriRequest(taskId), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public AsyncResult<Pageable<TaskResponse>> list() throws IOException, URISyntaxException {
        return this.list((Map)ImmutableMap.of());
    }

    @Override
    public AsyncResult<Pageable<TaskResponse>> list(@NotNull Map<Filter, String> filters) throws IOException, URISyntaxException {
        return this.list((Map)filters, (List)ImmutableList.of());
    }

    @Override
    public AsyncResult<Pageable<TaskResponse>> list(@NotNull Map<Filter, String> filters, @NotNull List<Include> includes) throws IOException, URISyntaxException {
        return this.list((Map)filters, (List)includes, (Pagination)null);
    }

    @Override
    public AsyncResult<Pageable<TaskResponse>> list(@NotNull Map<Filter, String> filters, @NotNull List<Include> includes, @Nullable Pagination pagination) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getListHttpUriRequest(filters, includes, pagination), TASK_RESPONSE_PAGEABLE_TYPE_REFERENCE);
    }

    @Override
    public AsyncResult<TaskResponse> cancel(@NotNull String taskId) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getCancelHttpUriRequest(taskId), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public AsyncResult<TaskResponse> retry(@NotNull String taskId) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getRetryHttpUriRequest(taskId), TASK_RESPONSE_TYPE_REFERENCE);
    }

    @Override
    public AsyncResult<Void> delete(@NotNull String taskId) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getDeleteHttpUriRequest(taskId), VOID_TYPE_REFERENCE);
    }

    @Override
    public AsyncResult<Pageable<OperationResponse>> operations() throws IOException, URISyntaxException {
        return this.operations((Map)ImmutableMap.of());
    }

    @Override
    public AsyncResult<Pageable<OperationResponse>> operations(@NotNull Map<Filter, String> filters) throws IOException, URISyntaxException {
        return this.operations((Map)filters, (List)ImmutableList.of());
    }

    @Override
    public AsyncResult<Pageable<OperationResponse>> operations(@NotNull Map<Filter, String> filters, @NotNull List<Include> includes) throws IOException, URISyntaxException {
        return this.operations((Map)filters, (List)includes, (Boolean)null);
    }

    @Override
    public AsyncResult<Pageable<OperationResponse>> operations(@NotNull Map<Filter, String> filters, @NotNull List<Include> includes, @Nullable Boolean alternative) throws IOException, URISyntaxException {
        return this.asyncRequestExecutor.execute(this.getOperationsHttpUriRequest(filters, includes, alternative), OPERATION_RESPONSE_PAGEABLE_TYPE_REFERENCE);
    }

    @Override
    public AsyncResult<TaskResponse> convert(@NotNull ConvertFilesTaskRequest convertFilesTaskRequest) throws IOException, URISyntaxException {
        return (AsyncResult)this.getAbstractConvertFilesResource().convert(convertFilesTaskRequest);
    }

    @Override
    public AsyncResult<Pageable<OperationResponse>> convertFormats() throws IOException, URISyntaxException {
        return (AsyncResult)this.getAbstractConvertFilesResource().convertFormats();
    }

    @Override
    public AsyncResult<Pageable<OperationResponse>> convertFormats(@NotNull Map<Filter, String> filters) throws IOException, URISyntaxException {
        return (AsyncResult)this.getAbstractConvertFilesResource().convertFormats(filters);
    }

    @Override
    public AsyncResult<Pageable<OperationResponse>> convertFormats(@NotNull Map<Filter, String> filters, @NotNull List<Include> includes) throws IOException, URISyntaxException {
        return (AsyncResult)this.getAbstractConvertFilesResource().convertFormats(filters, includes);
    }

    @Override
    public AsyncResult<Pageable<OperationResponse>> convertFormats(@NotNull Map<Filter, String> filters, @NotNull List<Include> includes, @Nullable Boolean alternative) throws IOException, URISyntaxException {
        return (AsyncResult)this.getAbstractConvertFilesResource().convertFormats(filters, includes, alternative);
    }

    @Override
    public AsyncResult<TaskResponse> optimize(@NotNull OptimizeFilesTaskRequest optimizeFilesTaskRequest) throws IOException, URISyntaxException {
        return (AsyncResult)this.getAbstractOptimizeFilesResource().optimize(optimizeFilesTaskRequest);
    }

    @Override
    public AsyncResult<TaskResponse> capture(@NotNull CaptureWebsitesTaskRequest captureWebsitesTaskRequest) throws IOException, URISyntaxException {
        return (AsyncResult)this.getAbstractCaptureWebsitesResource().capture(captureWebsitesTaskRequest);
    }

    @Override
    public AsyncResult<TaskResponse> merge(@NotNull MergeFilesTaskRequest mergeFilesTaskRequest) throws IOException, URISyntaxException {
        return (AsyncResult)this.getAbstractMergeFilesResource().merge(mergeFilesTaskRequest);
    }

    @Override
    public AsyncResult<TaskResponse> archive(@NotNull CreateArchivesTaskRequest createArchivesTaskRequest) throws IOException, URISyntaxException {
        return (AsyncResult)this.getAbstractCreateArchivesResource().archive(createArchivesTaskRequest);
    }

    @Override
    public AsyncResult<TaskResponse> command(@NotNull ExecuteCommandsTaskRequest executeCommandsTaskRequest) throws IOException, URISyntaxException {
        return (AsyncResult)this.getAbstractExecuteCommandsResource().command(executeCommandsTaskRequest);
    }

    @Override
    public AsyncResult<TaskResponse> thumbnail(@NotNull CreateThumbnailsTaskRequest createThumbnailsTaskRequest) throws IOException, URISyntaxException {
        return (AsyncResult)this.getAbstractCreateThumbnailsResource().thumbnail(createThumbnailsTaskRequest);
    }

    @Override
    public AsyncResult<TaskResponse> metadata(@NotNull GetMetadataTaskRequest getMetadataTaskRequest) throws IOException, URISyntaxException {
        return (AsyncResult)this.getAbstractGetMetadataResource().metadata(getMetadataTaskRequest);
    }

    @Override
    public void close() throws IOException {
        this.asyncRequestExecutor.close();
        super.close();
    }
}

