/*
 * Decompiled with CFR 0.152.
 */
package com.cloudconvert.dto.result;

import com.cloudconvert.dto.result.AbstractResult;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class Result<T>
extends AbstractResult<T> {
    private int status;
    private Map<String, String> headers;
    private String message;
    @Nullable
    private T body;

    Result(int status, Map<String, String> headers, String message, @Nullable T body) {
        this.status = status;
        this.headers = headers;
        this.message = message;
        this.body = body;
    }

    public static <T> ResultBuilder<T> builder() {
        return new ResultBuilder();
    }

    public int getStatus() {
        return this.status;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getMessage() {
        return this.message;
    }

    @Nullable
    public T getBody() {
        return this.body;
    }

    public static class ResultBuilder<T> {
        private int status;
        private Map<String, String> headers;
        private String message;
        private T body;

        ResultBuilder() {
        }

        public ResultBuilder<T> status(int status) {
            this.status = status;
            return this;
        }

        public ResultBuilder<T> headers(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public ResultBuilder<T> message(String message) {
            this.message = message;
            return this;
        }

        public ResultBuilder<T> body(@Nullable T body) {
            this.body = body;
            return this;
        }

        public Result<T> build() {
            return new Result<T>(this.status, this.headers, this.message, this.body);
        }

        public String toString() {
            return "Result.ResultBuilder(status=" + this.status + ", headers=" + this.headers + ", message=" + this.message + ", body=" + this.body + ")";
        }
    }
}

