/*
 * Decompiled with CFR 0.152.
 */
package org.zendesk.client.v2;

import com.ning.http.client.Response;
import java.io.IOException;
import java.text.MessageFormat;
import org.zendesk.client.v2.ZendeskException;

public class ZendeskResponseException
extends ZendeskException {
    private static final long serialVersionUID = 1L;
    private int statusCode;
    private String statusText;
    private String body;

    public ZendeskResponseException(Response resp) throws IOException {
        this(resp.getStatusCode(), resp.getStatusText(), resp.getResponseBody());
    }

    public ZendeskResponseException(int statusCode, String statusText, String body) {
        super(MessageFormat.format("HTTP/{0}: {1}", statusCode, statusText));
        this.statusCode = statusCode;
        this.statusText = statusText;
        this.body = body;
    }

    public ZendeskResponseException(ZendeskResponseException cause) {
        super(cause.getMessage(), cause);
        this.statusCode = cause.getStatusCode();
        this.statusText = cause.getStatusText();
        this.body = cause.getBody();
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public String getStatusText() {
        return this.statusText;
    }

    public String getBody() {
        return this.body;
    }
}

