/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.syslog;

import java.io.Serializable;
import java.util.Objects;

public class SDParam
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String paramName;
    private String paramValue;

    public SDParam(String paramName, String paramValue) {
        this.validateParamName(paramName);
        this.paramName = paramName;
        this.paramValue = paramValue;
    }

    public String getParamName() {
        return this.paramName;
    }

    public void setParamName(String paramName) {
        this.validateParamName(paramName);
        this.paramName = paramName;
    }

    public String getParamValue() {
        return this.paramValue;
    }

    public void setParamValue(String paramValue) {
        this.paramValue = paramValue;
    }

    private void validateParamName(String sdName) {
        if (null == sdName) {
            throw new IllegalArgumentException("PARAM-NAME cannot be null");
        }
        if (sdName.length() > 32) {
            throw new IllegalArgumentException("PARAM-NAME must be less than 32 characters: " + sdName);
        }
        if (sdName.contains("=")) {
            throw new IllegalArgumentException("PARAM-NAME cannot contain '='");
        }
        if (sdName.contains(" ")) {
            throw new IllegalArgumentException("PARAM-NAME cannot contain ' '");
        }
        if (sdName.contains("]")) {
            throw new IllegalArgumentException("PARAM-NAME cannot contain ']'");
        }
        if (sdName.contains("\"")) {
            throw new IllegalArgumentException("PARAM-NAME cannot contain '\"'");
        }
    }

    public int hashCode() {
        int hash = 7;
        hash = 59 * hash + Objects.hashCode(this.paramName);
        hash = 59 * hash + Objects.hashCode(this.paramValue);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SDParam other = (SDParam)obj;
        if (!Objects.equals(this.paramName, other.paramName)) {
            return false;
        }
        return Objects.equals(this.paramValue, other.paramValue);
    }

    public String toString() {
        return "SDParam{paramName=" + this.paramName + ", paramValue=" + this.paramValue + '}';
    }
}

