/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.impl;

import com.cloudbees.groovy.cps.Block;
import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.Next;
import com.cloudbees.groovy.cps.impl.ContinuationGroup;
import com.cloudbees.groovy.cps.impl.ContinuationPtr;
import com.cloudbees.groovy.cps.impl.ReferenceStackTrace;
import com.cloudbees.groovy.cps.impl.SourceLocation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

public class SpreadBlock
implements Block {
    private final SourceLocation loc;
    private final Block listExp;
    static final ContinuationPtr fixList = new ContinuationPtr(ContinuationImpl.class, "fixList");
    private static final long serialVersionUID = 1L;

    public SpreadBlock(SourceLocation loc, Block listExp) {
        this.loc = loc;
        this.listExp = listExp;
    }

    @Override
    public Next eval(Env e, Continuation k) {
        return new ContinuationImpl(e, k).then(this.listExp, e, fixList);
    }

    public static Object[] despreadList(Object[] list) {
        ArrayList<Object> expanded = new ArrayList<Object>();
        for (Object element : list) {
            if (element instanceof SpreadList) {
                Collections.addAll(expanded, ((SpreadList)element).expanded);
                continue;
            }
            expanded.add(element);
        }
        return expanded.toArray();
    }

    class ContinuationImpl
    extends ContinuationGroup {
        private final Env e;
        private final Continuation k;
        private static final long serialVersionUID = 1L;

        ContinuationImpl(Env e, Continuation k) {
            this.e = e;
            this.k = k;
        }

        public Next fixList(Object value) {
            try {
                return this.k.receive(new SpreadList(this.despreadList(value).toArray()));
            }
            catch (IllegalArgumentException t) {
                return this.throwException(this.e, t, SpreadBlock.this.loc, new ReferenceStackTrace());
            }
        }

        private List<Object> despreadList(Object value) {
            if (value == null) {
                return Collections.singletonList(null);
            }
            if (value instanceof List) {
                return (List)value;
            }
            if (value.getClass().isArray()) {
                return DefaultTypeTransformation.primitiveArrayToList((Object)value);
            }
            String error = "cannot spread the type " + value.getClass().getName() + " with value " + value;
            if (value instanceof Map) {
                error = error + ", did you mean to use the spread-map operator instead?";
            }
            throw new IllegalArgumentException(error);
        }
    }

    static class SpreadList
    implements Serializable {
        private final Object[] expanded;
        private static final long serialVersionUID = 1L;

        public SpreadList(Object[] expanded) {
            this.expanded = expanded;
        }
    }
}

