/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps.impl;

import com.cloudbees.groovy.cps.Block;
import com.cloudbees.groovy.cps.Continuable;
import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.CpsDefaultGroovyMethods;
import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.Next;
import com.cloudbees.groovy.cps.impl.Caller;
import com.cloudbees.groovy.cps.impl.ContinuationPtr;
import com.cloudbees.groovy.cps.impl.CpsCallableInvocation;
import com.cloudbees.groovy.cps.impl.ReferenceStackTrace;
import com.cloudbees.groovy.cps.impl.SourceLocation;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.CheckReturnValue;
import org.codehaus.groovy.reflection.CachedClass;
import org.codehaus.groovy.reflection.CachedMethod;
import org.codehaus.groovy.reflection.ReflectionCache;
import org.codehaus.groovy.runtime.metaclass.NewInstanceMetaMethod;

abstract class ContinuationGroup
implements Serializable {
    private static final long serialVersionUID = 1L;

    ContinuationGroup() {
    }

    public Next then(Block exp, Env e, ContinuationPtr ptr) {
        return new Next(exp, e, ptr.bind(this));
    }

    public Next then(Block exp, Env e, Continuation k) {
        return new Next(exp, e, k);
    }

    protected Next methodCall(Env e, SourceLocation loc, ContinuationPtr k, Object receiver, String methodName, Object ... args) {
        return this.methodCall(e, loc, k.bind(this), receiver, methodName, args);
    }

    protected Next methodCall(Env e, SourceLocation loc, Continuation k, Object receiver, String methodName, Object ... args) {
        try {
            Caller.record(receiver, methodName, args);
            Object v = e.getInvoker().methodCall(receiver, methodName, args);
            return k.receive(v);
        }
        catch (CpsCallableInvocation inv) {
            return inv.invoke(e, loc, k);
        }
        catch (Throwable t) {
            return this.throwException(e, t, loc, new ReferenceStackTrace());
        }
    }

    private void fixupStackTrace(Env e, Throwable t, SourceLocation loc, ReferenceStackTrace ref) {
        StackTraceElement[] ts;
        StackTraceElement[] rs = ref.getStackTrace();
        if (!this.hasSameRoots(rs, ts = t.getStackTrace())) {
            return;
        }
        List<StackTraceElement> orig = Arrays.asList(ts);
        int pos = ts.length - rs.length;
        ArrayList<StackTraceElement> stack = new ArrayList<StackTraceElement>(orig.subList(0, pos));
        stack.add((loc != null ? loc : SourceLocation.UNKNOWN).toStackTrace());
        e.buildStackTraceElements(stack, Integer.MAX_VALUE);
        stack.add(Continuable.SEPARATOR_STACK_ELEMENT);
        stack.addAll(orig.subList(pos, orig.size()));
        t.setStackTrace(stack.toArray(new StackTraceElement[stack.size()]));
    }

    private boolean hasSameRoots(StackTraceElement[] rs, StackTraceElement[] ts) {
        int b = ts.length - rs.length;
        if (b < 0) {
            return false;
        }
        StackTraceElement lhs = ts[b];
        StackTraceElement rhs = rs[0];
        if (!(this.eq(lhs.getClassName(), rhs.getClassName()) && this.eq(lhs.getMethodName(), rhs.getMethodName()) && this.eq(lhs.getFileName(), rhs.getFileName()))) {
            return false;
        }
        for (int i = 1; i < rs.length; ++i) {
            if (ts[b + i].equals(rs[i])) continue;
            return false;
        }
        return true;
    }

    private boolean eq(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    @CheckReturnValue
    protected Next throwException(Env e, Throwable t, SourceLocation loc, ReferenceStackTrace ref) {
        this.fixupStackTrace(e, t, loc, ref);
        return e.getExceptionHandler(t.getClass()).receive(t);
    }

    static {
        for (CachedMethod m : ReflectionCache.getCachedClass(CpsDefaultGroovyMethods.class).getMethods()) {
            CachedClass[] paramTypes = m.getParameterTypes();
            if (paramTypes.length <= 0) continue;
            paramTypes[0].addNewMopMethods(Collections.singletonList(new NewInstanceMetaMethod(m)));
        }
    }
}

