/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps;

import com.cloudbees.groovy.cps.Block;
import com.cloudbees.groovy.cps.CaseExpression;
import com.cloudbees.groovy.cps.CatchExpression;
import com.cloudbees.groovy.cps.LValueBlock;
import com.cloudbees.groovy.cps.MethodLocation;
import com.cloudbees.groovy.cps.impl.ArrayAccessBlock;
import com.cloudbees.groovy.cps.impl.AssertBlock;
import com.cloudbees.groovy.cps.impl.AssignmentBlock;
import com.cloudbees.groovy.cps.impl.AttributeAccessBlock;
import com.cloudbees.groovy.cps.impl.BlockScopedBlock;
import com.cloudbees.groovy.cps.impl.BreakBlock;
import com.cloudbees.groovy.cps.impl.ClosureBlock;
import com.cloudbees.groovy.cps.impl.ConstantBlock;
import com.cloudbees.groovy.cps.impl.ContinueBlock;
import com.cloudbees.groovy.cps.impl.DoWhileBlock;
import com.cloudbees.groovy.cps.impl.ElvisBlock;
import com.cloudbees.groovy.cps.impl.ExcrementOperatorBlock;
import com.cloudbees.groovy.cps.impl.ForInLoopBlock;
import com.cloudbees.groovy.cps.impl.ForLoopBlock;
import com.cloudbees.groovy.cps.impl.FunctionCallBlock;
import com.cloudbees.groovy.cps.impl.IfBlock;
import com.cloudbees.groovy.cps.impl.ListBlock;
import com.cloudbees.groovy.cps.impl.LocalVariableBlock;
import com.cloudbees.groovy.cps.impl.LogicalOpBlock;
import com.cloudbees.groovy.cps.impl.MapBlock;
import com.cloudbees.groovy.cps.impl.NewArrayBlock;
import com.cloudbees.groovy.cps.impl.NotBlock;
import com.cloudbees.groovy.cps.impl.PropertyAccessBlock;
import com.cloudbees.groovy.cps.impl.ReturnBlock;
import com.cloudbees.groovy.cps.impl.SequenceBlock;
import com.cloudbees.groovy.cps.impl.SourceLocation;
import com.cloudbees.groovy.cps.impl.StaticFieldBlock;
import com.cloudbees.groovy.cps.impl.SwitchBlock;
import com.cloudbees.groovy.cps.impl.ThrowBlock;
import com.cloudbees.groovy.cps.impl.TryCatchBlock;
import com.cloudbees.groovy.cps.impl.VariableDeclBlock;
import com.cloudbees.groovy.cps.impl.WhileBlock;
import groovy.lang.Closure;
import java.util.Arrays;
import java.util.List;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Builder {
    private MethodLocation loc;
    private static final Block NULL = new ConstantBlock(null);
    private static final LValueBlock THIS = new LocalVariableBlock("this");

    public Builder(MethodLocation loc) {
        this.loc = loc;
    }

    public Object with(Closure c) {
        return c.call((Object)this);
    }

    public Block null_() {
        return NULL;
    }

    public Block noop() {
        return Block.NOOP;
    }

    public Block constant(Object o) {
        return new ConstantBlock(o);
    }

    public Block zero() {
        return this.constant(0);
    }

    public Block one() {
        return this.constant(1);
    }

    public Block two() {
        return this.constant(2);
    }

    public Block true_() {
        return this.constant(true);
    }

    public Block false_() {
        return this.constant(false);
    }

    public Block block(Block ... bodies) {
        if (bodies.length == 0) {
            return NULL;
        }
        Block e = bodies[0];
        for (int i = 1; i < bodies.length; ++i) {
            e = this.sequence(e, bodies[i]);
        }
        return this.blockScoped(e);
    }

    private Block blockScoped(Block exp) {
        return new BlockScopedBlock(exp);
    }

    public Block sequence(Block ... bodies) {
        if (bodies.length == 0) {
            return NULL;
        }
        Block e = bodies[0];
        for (int i = 1; i < bodies.length; ++i) {
            e = this.sequence(e, bodies[i]);
        }
        return e;
    }

    public Block sequence(Block exp1, Block exp2) {
        return new SequenceBlock(exp1, exp2);
    }

    public Block sequence(Block b) {
        return b;
    }

    public Block closure(List<String> parameters, Block body) {
        return new ClosureBlock(parameters, body);
    }

    public LValueBlock localVariable(String name) {
        return new LocalVariableBlock(name);
    }

    public Block setLocalVariable(int line, String name, Block rhs) {
        return this.assign(line, this.localVariable(name), rhs);
    }

    public Block declareVariable(Class type, String name) {
        return new VariableDeclBlock(type, name);
    }

    public Block declareVariable(int line, Class type, String name, Block init) {
        return this.sequence(this.declareVariable(type, name), this.setLocalVariable(line, name, init));
    }

    public Block this_() {
        return THIS;
    }

    public Block localVariableAssignOp(int line, String name, String operator, Block rhs) {
        return this.setLocalVariable(line, name, this.functionCall(line, (Block)this.localVariable(name), operator, rhs));
    }

    public Block if_(Block cond, Block then, Block els) {
        return new IfBlock(cond, then, els);
    }

    public Block if_(Block cond, Block then) {
        return this.if_(cond, then, Block.NOOP);
    }

    public Block forLoop(String label, Block e1, Block e2, Block e3, Block body) {
        return new ForLoopBlock(label, e1, e2, e3, body);
    }

    public Block forInLoop(int line, String label, Class type, String variable, Block collection, Block body) {
        return new ForInLoopBlock(this.loc(line), label, type, variable, collection, body);
    }

    public Block break_(String label) {
        if (label == null) {
            return BreakBlock.INSTANCE;
        }
        return new BreakBlock(label);
    }

    public Block continue_(String label) {
        if (label == null) {
            return ContinueBlock.INSTANCE;
        }
        return new ContinueBlock(label);
    }

    public Block while_(String label, Block cond, Block body) {
        return new WhileBlock(label, cond, body);
    }

    public Block doWhile(String label, Block body, Block cond) {
        return new DoWhileBlock(label, body, cond);
    }

    public Block tryCatch(Block body, Block finally_, CatchExpression ... catches) {
        return this.tryCatch(body, Arrays.asList(catches), finally_);
    }

    public Block tryCatch(Block body, List<CatchExpression> catches) {
        return this.tryCatch(body, catches, null);
    }

    public Block tryCatch(Block body, List<CatchExpression> catches, Block finally_) {
        return new TryCatchBlock(catches, body, finally_);
    }

    public Block throw_(Block exp) {
        return new ThrowBlock(exp);
    }

    public Block map(Block ... blocks) {
        return new MapBlock(blocks);
    }

    public Block map(List<Block> blocks) {
        return this.map(blocks.toArray(new Block[blocks.size()]));
    }

    public Block staticCall(int line, Class lhs, String name, Block ... argExps) {
        return this.functionCall(line, this.constant(lhs), name, argExps);
    }

    public Block plus(int line, Block lhs, Block rhs) {
        return this.functionCall(line, lhs, "plus", rhs);
    }

    public Block plusEqual(int line, LValueBlock lhs, Block rhs) {
        return new AssignmentBlock(this.loc(line), lhs, rhs, "plus");
    }

    public Block minus(int line, Block lhs, Block rhs) {
        return this.functionCall(line, lhs, "minus", rhs);
    }

    public Block minusEqual(int line, LValueBlock lhs, Block rhs) {
        return new AssignmentBlock(this.loc(line), lhs, rhs, "minus");
    }

    public Block multiply(int line, Block lhs, Block rhs) {
        return this.functionCall(line, lhs, "multiply", rhs);
    }

    public Block multiplyEqual(int line, LValueBlock lhs, Block rhs) {
        return new AssignmentBlock(this.loc(line), lhs, rhs, "multiply");
    }

    public Block div(int line, Block lhs, Block rhs) {
        return this.functionCall(line, lhs, "div", rhs);
    }

    public Block divEqual(int line, LValueBlock lhs, Block rhs) {
        return new AssignmentBlock(this.loc(line), lhs, rhs, "div");
    }

    public Block intdiv(int line, Block lhs, Block rhs) {
        return this.functionCall(line, lhs, "intdiv", rhs);
    }

    public Block intdivEqual(int line, LValueBlock lhs, Block rhs) {
        return new AssignmentBlock(this.loc(line), lhs, rhs, "intdiv");
    }

    public Block mod(int line, Block lhs, Block rhs) {
        return this.functionCall(line, lhs, "mod", rhs);
    }

    public Block modEqual(int line, LValueBlock lhs, Block rhs) {
        return new AssignmentBlock(this.loc(line), lhs, rhs, "mod");
    }

    public Block power(int line, Block lhs, Block rhs) {
        return this.functionCall(line, lhs, "power", rhs);
    }

    public Block powerEqual(int line, LValueBlock lhs, Block rhs) {
        return new AssignmentBlock(this.loc(line), lhs, rhs, "power");
    }

    public Block unaryMinus(int line, Block lhs) {
        return this.staticCall(line, ScriptBytecodeAdapter.class, "unaryMinus", lhs);
    }

    public Block unaryPlus(int line, Block lhs) {
        return this.staticCall(line, ScriptBytecodeAdapter.class, "unaryPlus", lhs);
    }

    public Block ternaryOp(Block cond, Block trueExp, Block falseExp) {
        return this.if_(cond, trueExp, falseExp);
    }

    public Block elvisOp(Block cond, Block falseExp) {
        return new ElvisBlock(cond, falseExp);
    }

    public Block compareEqual(int line, Block lhs, Block rhs) {
        return this.staticCall(line, ScriptBytecodeAdapter.class, "compareEqual", lhs, rhs);
    }

    public Block compareNotEqual(int line, Block lhs, Block rhs) {
        return this.staticCall(line, ScriptBytecodeAdapter.class, "compareNotEqual", lhs, rhs);
    }

    public Block compareTo(int line, Block lhs, Block rhs) {
        return this.staticCall(line, ScriptBytecodeAdapter.class, "compareTo", lhs, rhs);
    }

    public Block lessThan(int line, Block lhs, Block rhs) {
        return this.staticCall(line, ScriptBytecodeAdapter.class, "compareLessThan", lhs, rhs);
    }

    public Block lessThanEqual(int line, Block lhs, Block rhs) {
        return this.staticCall(line, ScriptBytecodeAdapter.class, "compareLessThanEqual", lhs, rhs);
    }

    public Block greaterThan(int line, Block lhs, Block rhs) {
        return this.staticCall(line, ScriptBytecodeAdapter.class, "compareGreaterThan", lhs, rhs);
    }

    public Block greaterThanEqual(int line, Block lhs, Block rhs) {
        return this.staticCall(line, ScriptBytecodeAdapter.class, "compareGreaterThanEqual", lhs, rhs);
    }

    public Block findRegex(int line, Block lhs, Block rhs) {
        return this.staticCall(line, ScriptBytecodeAdapter.class, "findRegex", lhs, rhs);
    }

    public Block matchRegex(int line, Block lhs, Block rhs) {
        return this.staticCall(line, ScriptBytecodeAdapter.class, "matchRegex", lhs, rhs);
    }

    public Block isCase(int line, Block lhs, Block rhs) {
        return this.staticCall(line, ScriptBytecodeAdapter.class, "isCase", lhs, rhs);
    }

    public Block logicalAnd(int line, Block lhs, Block rhs) {
        return new LogicalOpBlock(lhs, rhs, true);
    }

    public Block logicalOr(int line, Block lhs, Block rhs) {
        return new LogicalOpBlock(lhs, rhs, false);
    }

    public Block leftShift(int line, Block lhs, Block rhs) {
        return this.functionCall(line, lhs, "leftShift", rhs);
    }

    public Block leftShiftEqual(int line, LValueBlock lhs, Block rhs) {
        return new AssignmentBlock(this.loc(line), lhs, rhs, "leftShift");
    }

    public Block rightShift(int line, Block lhs, Block rhs) {
        return this.functionCall(line, lhs, "rightShift", rhs);
    }

    public Block rightShiftEqual(int line, LValueBlock lhs, Block rhs) {
        return new AssignmentBlock(this.loc(line), lhs, rhs, "rightShift");
    }

    public Block rightShiftUnsigned(int line, Block lhs, Block rhs) {
        return this.functionCall(line, lhs, "rightShiftUnsigned", rhs);
    }

    public Block rightShiftUnsignedEqual(int line, LValueBlock lhs, Block rhs) {
        return new AssignmentBlock(this.loc(line), lhs, rhs, "rightShiftUnsigned");
    }

    public Block not(int line, Block b) {
        return new NotBlock(b);
    }

    public Block bitwiseAnd(int line, Block lhs, Block rhs) {
        return this.functionCall(line, lhs, "and", rhs);
    }

    public Block bitwiseAndEqual(int line, LValueBlock lhs, Block rhs) {
        return new AssignmentBlock(this.loc(line), lhs, rhs, "and");
    }

    public Block bitwiseOr(int line, Block lhs, Block rhs) {
        return this.functionCall(line, lhs, "or", rhs);
    }

    public Block bitwiseOrEqual(int line, LValueBlock lhs, Block rhs) {
        return new AssignmentBlock(this.loc(line), lhs, rhs, "or");
    }

    public Block bitwiseXor(int line, Block lhs, Block rhs) {
        return this.functionCall(line, lhs, "xor", rhs);
    }

    public Block bitwiseXorEqual(int line, LValueBlock lhs, Block rhs) {
        return new AssignmentBlock(this.loc(line), lhs, rhs, "xor");
    }

    public Block bitwiseNegation(int line, Block b) {
        return this.staticCall(line, ScriptBytecodeAdapter.class, "bitwiseNegate", b);
    }

    public Block prefixInc(int line, LValueBlock body) {
        return new ExcrementOperatorBlock(this.loc(line), "next", true, body);
    }

    public Block prefixDec(int line, LValueBlock body) {
        return new ExcrementOperatorBlock(this.loc(line), "previous", true, body);
    }

    public Block postfixInc(int line, LValueBlock body) {
        return new ExcrementOperatorBlock(this.loc(line), "next", false, body);
    }

    public Block postfixDec(int line, LValueBlock body) {
        return new ExcrementOperatorBlock(this.loc(line), "previous", false, body);
    }

    public Block cast(int line, Block block, Class type, boolean coerce) {
        return this.staticCall(line, ScriptBytecodeAdapter.class, coerce ? "asType" : "castToType", block, this.constant(type));
    }

    public Block instanceOf(int line, Block value, Block type) {
        return this.functionCall(line, type, "isInstance", value);
    }

    public Block functionCall(int line, Block lhs, String name, Block ... argExps) {
        return new FunctionCallBlock(this.loc(line), lhs, this.constant(name), argExps);
    }

    public Block functionCall(int line, Block lhs, Block name, Block ... argExps) {
        return new FunctionCallBlock(this.loc(line), lhs, name, argExps);
    }

    public Block assign(int line, LValueBlock lhs, Block rhs) {
        return new AssignmentBlock(this.loc(line), lhs, rhs, null);
    }

    public LValueBlock property(int line, Block lhs, String property) {
        return this.property(line, lhs, this.constant(property));
    }

    public LValueBlock property(int line, Block lhs, Block property) {
        return new PropertyAccessBlock(this.loc(line), lhs, property);
    }

    public LValueBlock array(int line, Block lhs, Block index) {
        return new ArrayAccessBlock(this.loc(line), lhs, index);
    }

    public LValueBlock attribute(int line, Block lhs, Block property) {
        return new AttributeAccessBlock(this.loc(line), lhs, property);
    }

    public LValueBlock staticField(int line, Class type, String name) {
        return new StaticFieldBlock(this.loc(line), type, name);
    }

    public Block setProperty(int line, Block lhs, String property, Block rhs) {
        return this.setProperty(line, lhs, this.constant(property), rhs);
    }

    public Block setProperty(int line, Block lhs, Block property, Block rhs) {
        return this.assign(line, this.property(line, lhs, property), rhs);
    }

    public Block new_(int line, Class type, Block ... argExps) {
        return this.new_(line, this.constant(type), argExps);
    }

    public Block new_(int line, Block type, Block ... argExps) {
        return new FunctionCallBlock(this.loc(line), type, this.constant("<init>"), argExps);
    }

    public Block newArray(int line, Class type, Block ... argExps) {
        return new NewArrayBlock(this.loc(line), type, argExps);
    }

    public Block return_(Block exp) {
        return new ReturnBlock(exp);
    }

    public Block list(Block ... args) {
        return new ListBlock(args);
    }

    public Block range(int line, Block from, Block to, boolean inclusive) {
        return this.staticCall(line, ScriptBytecodeAdapter.class, "createRange", from, to, this.constant(inclusive));
    }

    public Block assert_(Block cond, Block msg, String sourceText) {
        return new AssertBlock(cond, msg, sourceText);
    }

    public Block assert_(Block cond, String sourceText) {
        return this.assert_(cond, this.null_(), sourceText);
    }

    public Block gstring(int line, Block listOfValues, Block listOfStrings) {
        return this.new_(line, GStringImpl.class, this.cast(line, listOfValues, Object[].class, true), this.cast(line, listOfStrings, String[].class, true));
    }

    public Block switch_(String label, Block switchExp, Block defaultStmt, CaseExpression ... caseExps) {
        return new SwitchBlock(label, switchExp, defaultStmt, Arrays.asList(caseExps));
    }

    public CaseExpression case_(int line, Block matcher, Block body) {
        return new CaseExpression(this.loc(line), matcher, body);
    }

    private SourceLocation loc(int line) {
        return new SourceLocation(this.loc, line);
    }
}

