/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.groovy.cps;

import com.cloudbees.groovy.cps.Block;
import com.cloudbees.groovy.cps.Continuation;
import com.cloudbees.groovy.cps.Env;
import com.cloudbees.groovy.cps.Next;
import com.cloudbees.groovy.cps.Outcome;
import com.cloudbees.groovy.cps.WorkflowTransformed;
import com.cloudbees.groovy.cps.impl.CpsCallableInvocation;
import com.cloudbees.groovy.cps.impl.FunctionCallEnv;
import com.cloudbees.groovy.cps.impl.SuspendBlock;
import groovy.lang.Script;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Continuable
implements Serializable {
    private Env e;
    private Continuation k;
    private static final long serialVersionUID = 1L;
    public static final StackTraceElement SEPARATOR_STACK_ELEMENT = new StackTraceElement("___cps", "transform___", null, -2);

    public Continuable(Continuable src) {
        this.e = src.e;
        this.k = src.k;
    }

    public Continuable(Next n) {
        this.e = n.e;
        this.k = n;
    }

    public Continuable(Block block) {
        this(block, new FunctionCallEnv(null, null, null, Continuation.HALT));
    }

    public Continuable(Block block, Env e) {
        this.e = e;
        this.k = new Next(block, e, Continuation.HALT);
    }

    public Continuable(Script cpsTransformedScript) {
        this(Continuable.wrap(cpsTransformedScript));
    }

    private static Next wrap(Script s) {
        try {
            Method m = s.getClass().getMethod("run", new Class[0]);
            if (!m.isAnnotationPresent(WorkflowTransformed.class)) {
                throw new IllegalArgumentException(s + " is not CPS-transformed");
            }
            s.run();
            throw new AssertionError((Object)"I'm confused if Script is CPS-transformed or not!");
        }
        catch (CpsCallableInvocation e) {
            return e.invoke(null, null, Continuation.HALT);
        }
        catch (NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    public Continuable fork() {
        return new Continuable(this);
    }

    public Object run(Object arg) throws InvocationTargetException {
        return this.run0(new Outcome(arg, null)).wrapReplay();
    }

    public Object runByThrow(Throwable arg) throws InvocationTargetException {
        return this.run0(new Outcome(null, arg)).wrapReplay();
    }

    public Outcome run0(Outcome cn) {
        Next n = cn.resumeFrom(this.e, this.k);
        n = n.run();
        this.e = n.e;
        this.k = n.k;
        return n.yield;
    }

    public boolean isResumable() {
        return this.k != Continuation.HALT || this.e != null;
    }

    public static Object suspend(Object v) {
        throw new CpsCallableInvocation(SuspendBlock.SUSPEND, null, v);
    }

    public List<StackTraceElement> getStackTrace() {
        ArrayList<StackTraceElement> r = new ArrayList<StackTraceElement>();
        if (this.e != null) {
            this.e.buildStackTraceElements(r, Integer.MAX_VALUE);
        }
        return r;
    }
}

