/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.sync.replication;

import android.app.Service;
import android.content.Intent;
import android.net.wifi.WifiManager;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.Parcelable;
import android.support.v4.content.WakefulBroadcastReceiver;
import com.cloudant.sync.replication.PolicyReplicationsCompletedListener;
import com.cloudant.sync.replication.ReplicationPolicyManager;
import com.cloudant.sync.replication.Replicator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class ReplicationService
extends Service
implements PolicyReplicationsCompletedListener {
    public static final String EXTRA_INTENT = "intent";
    public static final String EXTRA_COMMAND = "command";
    public static final int COMMAND_NONE = -1;
    public static final int COMMAND_START_REPLICATION = 0;
    public static final int COMMAND_STOP_REPLICATION = 1;
    private static final int INTERNALLY_RESERVED_COMMAND_MAX_USED = 5;
    private static final int INTERNALLY_RESERVED_COMMAND_MAX = 99;
    private Handler mServiceHandler;
    private ReplicationPolicyManager mReplicationPolicyManager;
    private boolean mReplicatorsInitialised;
    private List<Message> mCommandQueue = new ArrayList<Message>();
    private Intent mStartReplicationsIntent;
    private int mStartReplicationsId;
    private final Set<PolicyReplicationsCompletedListener> mListeners = new HashSet<PolicyReplicationsCompletedListener>();
    private WifiManager.WifiLock mWifiLock;
    private OperationStartedListener mOperationStartedListener;
    private final IBinder mBinder = new LocalBinder();

    protected Handler getHandler(Looper looper) {
        return new ServiceHandler(looper);
    }

    public void onCreate() {
        super.onCreate();
        WifiManager wifiManager = (WifiManager)this.getSystemService("wifi");
        if (wifiManager != null) {
            this.mWifiLock = wifiManager.createWifiLock(3, "ReplicationService");
        }
        HandlerThread thread = new HandlerThread("ServiceStartArguments", 10);
        thread.start();
        Looper serviceLooper = thread.getLooper();
        this.mServiceHandler = this.getHandler(serviceLooper);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setReplicators(Replicator[] replicators) {
        if (this.mReplicatorsInitialised) {
            throw new IllegalStateException("Replicators already set");
        }
        if (replicators != null && replicators.length > 0) {
            if (this.mReplicationPolicyManager == null) {
                this.mReplicationPolicyManager = new ReplicationPolicyManager();
            }
            this.mReplicationPolicyManager.addReplicators(replicators);
            this.mReplicationPolicyManager.setReplicationsCompletedListener((PolicyReplicationsCompletedListener)this);
            List<Message> list = this.mCommandQueue;
            synchronized (list) {
                this.mReplicatorsInitialised = true;
                for (Message msg : this.mCommandQueue) {
                    this.mServiceHandler.sendMessage(msg);
                }
                this.mCommandQueue.clear();
            }
        } else {
            throw new IllegalArgumentException("No replications setup. Please pass Replicators to setReplicators(Replicator[])");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int onStartCommand(Intent intent, int flags, int startId) {
        if (intent != null && intent.hasExtra(EXTRA_COMMAND)) {
            Message msg = this.mServiceHandler.obtainMessage();
            msg.arg1 = startId;
            msg.arg2 = intent.getIntExtra(EXTRA_COMMAND, 1);
            Bundle bundle = new Bundle();
            bundle.putParcelable(EXTRA_INTENT, (Parcelable)intent);
            msg.setData(bundle);
            List<Message> list = this.mCommandQueue;
            synchronized (list) {
                if (this.mReplicatorsInitialised) {
                    this.mServiceHandler.sendMessage(msg);
                } else if (this.mCommandQueue.size() == 0 || this.mCommandQueue.get((int)(this.mCommandQueue.size() - 1)).arg2 != msg.arg2) {
                    this.mCommandQueue.add(msg);
                }
            }
        }
        return 3;
    }

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    public boolean onUnbind(Intent intent) {
        return true;
    }

    public void onRebind(Intent intent) {
        super.onRebind(intent);
    }

    public void setReplicationPolicyManager(ReplicationPolicyManager replicationPolicyManager) {
        this.mReplicationPolicyManager = replicationPolicyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startReplications() {
        if (this.mReplicationPolicyManager != null) {
            if (this.mWifiLock != null) {
                WifiManager.WifiLock wifiLock = this.mWifiLock;
                synchronized (wifiLock) {
                    if (!this.mWifiLock.isHeld()) {
                        this.mWifiLock.acquire();
                    }
                }
            }
            this.mReplicationPolicyManager.startReplications();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseWifiLockIfHeld() {
        if (this.mWifiLock != null) {
            WifiManager.WifiLock wifiLock = this.mWifiLock;
            synchronized (wifiLock) {
                if (this.mWifiLock.isHeld()) {
                    this.mWifiLock.release();
                }
            }
        }
    }

    protected void releaseWakeLock(Intent intent) {
        if (intent != null) {
            WakefulBroadcastReceiver.completeWakefulIntent((Intent)intent);
        }
    }

    protected void stopReplications() {
        if (this.mReplicationPolicyManager != null) {
            this.mReplicationPolicyManager.stopReplications();
            this.releaseWifiLockIfHeld();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allReplicationsCompleted() {
        Set<PolicyReplicationsCompletedListener> set = this.mListeners;
        synchronized (set) {
            for (PolicyReplicationsCompletedListener listener : this.mListeners) {
                listener.allReplicationsCompleted();
            }
        }
        this.releaseWifiLockIfHeld();
        this.releaseWakeLock(this.mStartReplicationsIntent);
        this.stopSelf(this.mStartReplicationsId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicationCompleted(int id) {
        Set<PolicyReplicationsCompletedListener> set = this.mListeners;
        synchronized (set) {
            for (PolicyReplicationsCompletedListener listener : this.mListeners) {
                listener.replicationCompleted(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicationErrored(int id) {
        Set<PolicyReplicationsCompletedListener> set = this.mListeners;
        synchronized (set) {
            for (PolicyReplicationsCompletedListener listener : this.mListeners) {
                listener.replicationErrored(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(PolicyReplicationsCompletedListener listener) {
        Set<PolicyReplicationsCompletedListener> set = this.mListeners;
        synchronized (set) {
            this.mListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(PolicyReplicationsCompletedListener listener) {
        Set<PolicyReplicationsCompletedListener> set = this.mListeners;
        synchronized (set) {
            this.mListeners.remove(listener);
        }
    }

    public void setOperationStartedListener(OperationStartedListener listener) {
        this.mOperationStartedListener = listener;
    }

    void notifyOperationStarted(int operationId) {
        if (this.mOperationStartedListener != null) {
            this.mOperationStartedListener.operationStarted(operationId);
        }
    }

    protected class ServiceHandler
    extends Handler {
        public ServiceHandler(Looper looper) {
            super(looper);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void handleMessage(Message msg) {
            try {
                if (msg.arg2 > 5 && msg.arg2 <= 99) {
                    throw new RuntimeException("ReplicationService received an EXTRA_COMMAND using an id in the range reserved for internal use. Custom commands must use an id above 99");
                }
                Intent intent = (Intent)msg.getData().getParcelable(ReplicationService.EXTRA_INTENT);
                switch (msg.arg2) {
                    case 0: {
                        ReplicationService.this.mStartReplicationsIntent = intent;
                        ReplicationService.this.mStartReplicationsId = msg.arg1;
                        ReplicationService.this.startReplications();
                        return;
                    }
                    case 1: {
                        ReplicationService.this.stopReplications();
                        ReplicationService.this.releaseWakeLock(intent);
                        ReplicationService.this.stopSelf(msg.arg1);
                        return;
                    }
                }
                return;
            }
            finally {
                ReplicationService.this.notifyOperationStarted(msg.arg2);
            }
        }
    }

    public class LocalBinder
    extends Binder {
        public ReplicationService getService() {
            return ReplicationService.this;
        }
    }

    static interface OperationStartedListener {
        public void operationStarted(int var1);
    }
}

