/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.sync.internal.sqlite.android;

import android.database.SQLException;
import android.database.sqlite.SQLiteConstraintException;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import com.cloudant.sync.internal.android.ContentValues;
import com.cloudant.sync.internal.sqlite.Cursor;
import com.cloudant.sync.internal.sqlite.SQLDatabase;
import com.cloudant.sync.internal.sqlite.android.AndroidSQLiteCursor;
import com.cloudant.sync.internal.util.Misc;
import java.io.File;

public class AndroidSQLite
extends SQLDatabase {
    SQLiteDatabase database = null;

    public static AndroidSQLite open(File path) {
        SQLiteDatabase db = path != null ? SQLiteDatabase.openOrCreateDatabase((File)path, null) : SQLiteDatabase.create(null);
        return new AndroidSQLite(db);
    }

    public AndroidSQLite(SQLiteDatabase database) {
        this.database = database;
    }

    public void compactDatabase() {
        try {
            this.database.execSQL("VACUUM");
        }
        catch (SQLException e) {
            String error = "Fatal error running 'VACUUM', the database is probably malfunctioning.";
            throw new IllegalStateException(error);
        }
    }

    public void open() {
    }

    public void close() {
        this.database.close();
    }

    public boolean isOpen() {
        return this.database.isOpen();
    }

    public void beginTransaction() {
        this.database.beginTransaction();
    }

    public void endTransaction() {
        this.database.endTransaction();
    }

    public void setTransactionSuccessful() {
        this.database.setTransactionSuccessful();
    }

    public void execSQL(String sql) throws java.sql.SQLException {
        Misc.checkNotNullOrEmpty((String)sql.trim(), (String)"Input SQL");
        try {
            this.database.execSQL(sql);
        }
        catch (SQLException e) {
            throw new java.sql.SQLException(e);
        }
    }

    public void execSQL(String sql, Object[] bindArgs) throws java.sql.SQLException {
        Misc.checkNotNullOrEmpty((String)sql.trim(), (String)"Input SQL");
        try {
            this.database.execSQL(sql, bindArgs);
        }
        catch (SQLException e) {
            throw new java.sql.SQLException(e);
        }
    }

    public int getVersion() {
        return this.database.getVersion();
    }

    public int update(String table, ContentValues args, String whereClause, String[] whereArgs) {
        return this.database.update("\"" + table + "\"", this.createAndroidContentValues(args), whereClause, whereArgs);
    }

    public Cursor rawQuery(String sql, String[] values) throws java.sql.SQLException {
        try {
            return new AndroidSQLiteCursor(this.database.rawQuery(sql, values));
        }
        catch (SQLiteException e) {
            throw new java.sql.SQLException(e);
        }
    }

    public int delete(String table, String whereClause, String[] whereArgs) {
        return this.database.delete("\"" + table + "\"", whereClause, whereArgs);
    }

    public long insert(String table, ContentValues args) {
        return this.insertWithOnConflict(table, args, 0);
    }

    public long insertWithOnConflict(String table, ContentValues initialValues, int conflictAlgorithm) {
        try {
            return this.database.insertWithOnConflict("\"" + table + "\"", null, this.createAndroidContentValues(initialValues), conflictAlgorithm);
        }
        catch (SQLiteConstraintException sqlce) {
            return -1L;
        }
    }

    private android.content.ContentValues createAndroidContentValues(ContentValues values) {
        android.content.ContentValues newValues = new android.content.ContentValues(values.size());
        for (String key : values.keySet()) {
            Object value = values.get(key);
            if (value instanceof Boolean) {
                newValues.put(key, (Boolean)value);
                continue;
            }
            if (value instanceof Byte) {
                newValues.put(key, (Byte)value);
                continue;
            }
            if (value instanceof byte[]) {
                newValues.put(key, (byte[])value);
                continue;
            }
            if (value instanceof Double) {
                newValues.put(key, (Double)value);
                continue;
            }
            if (value instanceof Float) {
                newValues.put(key, (Float)value);
                continue;
            }
            if (value instanceof Integer) {
                newValues.put(key, (Integer)value);
                continue;
            }
            if (value instanceof Long) {
                newValues.put(key, (Long)value);
                continue;
            }
            if (value instanceof Short) {
                newValues.put(key, (Short)value);
                continue;
            }
            if (value instanceof String) {
                newValues.put(key, (String)value);
                continue;
            }
            if (value == null) {
                newValues.putNull(key);
                continue;
            }
            throw new IllegalArgumentException("Unsupported data type: " + value.getClass());
        }
        return newValues;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.database.isOpen()) {
            this.database.close();
        }
    }
}

