/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.http.internal.ok;

import com.cloudant.http.internal.DefaultHttpUrlConnectionFactory;
import com.squareup.okhttp.ConnectionSpec;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.OkUrlFactory;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;

public class OkHttpClientHttpUrlConnectionFactory
extends DefaultHttpUrlConnectionFactory {
    private final OkHttpClient client = new OkHttpClient();
    private final OkUrlFactory factory;
    private static final boolean okUsable;

    public static boolean isOkUsable() {
        return okUsable;
    }

    public OkHttpClientHttpUrlConnectionFactory() {
        this.client.setConnectionSpecs(Arrays.asList(ConnectionSpec.CLEARTEXT, new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).allEnabledTlsVersions().allEnabledCipherSuites().build()));
        this.factory = new OkUrlFactory(this.client);
    }

    @Override
    public HttpURLConnection openConnection(URL url) throws IOException {
        return this.factory.open(url);
    }

    @Override
    public void setProxy(URL proxyUrl) {
        super.setProxy(proxyUrl);
        this.client.setProxy(this.proxy);
    }

    public OkHttpClient getOkHttpClient() {
        return this.client;
    }

    static {
        Class<?> okFactoryClass;
        try {
            okFactoryClass = Class.forName("com.squareup.okhttp.OkUrlFactory");
        }
        catch (Throwable t) {
            okFactoryClass = null;
        }
        okUsable = okFactoryClass != null;
    }
}

