/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.http;

import com.cloudant.http.HttpConnectionInterceptorContext;
import com.cloudant.http.HttpConnectionRequestInterceptor;
import com.cloudant.http.HttpConnectionResponseInterceptor;
import com.cloudant.http.Version;
import com.cloudant.http.interceptors.BasicAuthInterceptor;
import com.cloudant.http.internal.DefaultHttpUrlConnectionFactory;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class HttpConnection {
    private static final Logger logger = Logger.getLogger(HttpConnection.class.getCanonicalName());
    private static final String USER_AGENT;
    private final String requestMethod;
    public final URL url;
    private final String contentType;
    private HttpURLConnection connection;
    private InputStreamGenerator input;
    private long inputLength;
    public final HashMap<String, String> requestProperties;
    public final List<HttpConnectionRequestInterceptor> requestInterceptors;
    public final List<HttpConnectionResponseInterceptor> responseInterceptors;
    public HttpUrlConnectionFactory connectionFactory = new DefaultHttpUrlConnectionFactory();
    private int numberOfRetries = 10;

    public HttpConnection(String requestMethod, URL url, String contentType) {
        this.requestMethod = requestMethod;
        this.url = url;
        this.contentType = contentType;
        this.requestProperties = new HashMap();
        this.requestInterceptors = new LinkedList<HttpConnectionRequestInterceptor>();
        this.responseInterceptors = new LinkedList<HttpConnectionResponseInterceptor>();
    }

    public HttpConnection setNumberOfRetries(int numberOfRetries) {
        this.numberOfRetries = numberOfRetries;
        return this;
    }

    public HttpConnection setRequestBody(String input) {
        try {
            byte[] inputBytes = input.getBytes("UTF-8");
            return this.setRequestBody(inputBytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public HttpConnection setRequestBody(byte[] input) {
        return this.setRequestBody(new ByteArrayInputStream(input), (long)input.length);
    }

    public HttpConnection setRequestBody(InputStream input) {
        return this.setRequestBody(input, -1L);
    }

    public HttpConnection setRequestBody(InputStream input, long inputLength) {
        try {
            return this.setRequestBody(new InputStreamWrappingGenerator(input, inputLength), inputLength);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error copying input stream for request body", e);
            throw new RuntimeException(e);
        }
    }

    public HttpConnection setRequestBody(InputStreamGenerator input) {
        return this.setRequestBody(input, -1L);
    }

    public HttpConnection setRequestBody(InputStreamGenerator input, long inputLength) {
        this.input = input;
        this.inputLength = inputLength;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpConnection execute() throws IOException {
        boolean retry = true;
        int n = this.numberOfRetries;
        while (retry && n-- > 0) {
            this.connection = this.connectionFactory.openConnection(this.url);
            this.connection.setRequestProperty("User-Agent", USER_AGENT);
            if (this.url.getUserInfo() != null) {
                this.requestInterceptors.add(0, new BasicAuthInterceptor(this.url.getUserInfo()));
            }
            this.connection.setDoInput(true);
            this.connection.setRequestMethod(this.requestMethod);
            if (this.contentType != null) {
                this.connection.setRequestProperty("Content-type", this.contentType);
            }
            if (this.input != null) {
                this.connection.setDoOutput(true);
                if (this.inputLength != -1L) {
                    this.connection.setFixedLengthStreamingMode((int)this.inputLength);
                } else {
                    this.connection.setChunkedStreamingMode(0);
                }
            }
            HttpConnectionInterceptorContext currentContext = new HttpConnectionInterceptorContext(this);
            for (HttpConnectionRequestInterceptor httpConnectionRequestInterceptor : this.requestInterceptors) {
                currentContext = httpConnectionRequestInterceptor.interceptRequest(currentContext);
            }
            for (Map.Entry entry : this.requestProperties.entrySet()) {
                this.connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            if (this.input != null) {
                InputStream is = this.input.getInputStream();
                OutputStream outputStream = this.connection.getOutputStream();
                try {
                    IOUtils.copyLarge((InputStream)is, (OutputStream)outputStream, (byte[])new byte[16384]);
                    outputStream.flush();
                }
                finally {
                    IOUtils.closeQuietly((InputStream)is);
                    IOUtils.closeQuietly((OutputStream)outputStream);
                }
            }
            for (HttpConnectionResponseInterceptor httpConnectionResponseInterceptor : this.responseInterceptors) {
                currentContext = httpConnectionResponseInterceptor.interceptResponse(currentContext);
            }
            retry = currentContext.replayRequest;
            if (n != 0) continue;
            logger.info("Maximum number of retries reached");
        }
        return this;
    }

    public String responseAsString() throws IOException {
        if (this.connection == null) {
            throw new IOException("Attempted to read response from server before calling execute()");
        }
        InputStream is = this.connection.getInputStream();
        String string = IOUtils.toString((InputStream)is);
        is.close();
        this.connection.disconnect();
        return string;
    }

    public byte[] responseAsBytes() throws IOException {
        if (this.connection == null) {
            throw new IOException("Attempted to read response from server before calling execute()");
        }
        InputStream is = this.connection.getInputStream();
        byte[] bytes = IOUtils.toByteArray((InputStream)is);
        is.close();
        this.connection.disconnect();
        return bytes;
    }

    public InputStream responseAsInputStream() throws IOException {
        if (this.connection == null) {
            throw new IOException("Attempted to read response from server before calling execute()");
        }
        InputStream is = this.connection.getInputStream();
        return is;
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    static {
        String ua = "java-cloudant-http/unknown";
        try {
            Class<?> clazz = Class.forName("com.cloudant.library.LibraryVersion");
            Version version = (Version)clazz.newInstance();
            ua = version.getUserAgentString();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Could not determine version string using default user-agent", e);
        }
        USER_AGENT = ua;
    }

    private static final class InputStreamWrappingGenerator
    implements InputStreamGenerator {
        private final InputStream inputStream;

        InputStreamWrappingGenerator(InputStream inputStream, long size) throws IOException {
            if (!inputStream.markSupported()) {
                byte[] inputBytes = size == -1L ? IOUtils.toByteArray((InputStream)inputStream) : IOUtils.toByteArray((InputStream)inputStream, (long)size);
                this.inputStream = new ByteArrayInputStream(inputBytes);
            } else {
                this.inputStream = inputStream;
            }
            this.inputStream.mark(Integer.MAX_VALUE);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.inputStream.reset();
            return this.inputStream;
        }
    }

    public static interface InputStreamGenerator {
        public InputStream getInputStream() throws IOException;
    }

    public static interface HttpUrlConnectionFactory {
        public HttpURLConnection openConnection(URL var1) throws IOException;

        public void setProxy(URL var1);
    }
}

