/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.http.internal.ok;

import com.cloudant.http.internal.DefaultHttpUrlConnectionFactory;
import com.cloudant.http.internal.ok.ProxyAuthenticator;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import okhttp3.Authenticator;
import okhttp3.ConnectionSpec;
import okhttp3.Credentials;
import okhttp3.OkHttpClient;
import okhttp3.OkUrlFactory;

public class OkHttpClientHttpUrlConnectionFactory
extends DefaultHttpUrlConnectionFactory {
    private static final Logger logger = Logger.getLogger(OkHttpClientHttpUrlConnectionFactory.class.getName());
    private final OkHttpClient.Builder clientBuilder = new OkHttpClient().newBuilder();
    private OkUrlFactory factory = null;

    public OkHttpClientHttpUrlConnectionFactory() {
        this.clientBuilder.connectionSpecs(Arrays.asList(ConnectionSpec.CLEARTEXT, new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).allEnabledTlsVersions().allEnabledCipherSuites().build()));
    }

    @Override
    public HttpURLConnection openConnection(URL url) throws IOException {
        if (this.factory == null) {
            this.factory = new OkUrlFactory(this.clientBuilder.build());
        }
        return this.factory.open(url);
    }

    @Override
    public void setProxy(URL proxyUrl) {
        super.setProxy(proxyUrl);
        this.clientBuilder.proxy(this.proxy).build();
        logger.config(String.format("Configured HTTP proxy url %s", proxyUrl));
    }

    public OkHttpClient.Builder getOkHttpClientBuilder() {
        return this.clientBuilder;
    }

    @Override
    public void setProxyAuthentication(PasswordAuthentication proxyAuthentication) {
        this.clientBuilder.proxyAuthenticator((Authenticator)new ProxyAuthenticator(Credentials.basic((String)proxyAuthentication.getUserName(), (String)new String(proxyAuthentication.getPassword()))));
    }

    @Override
    public void shutdown() {
        try {
            this.factory.client().dispatcher().executorService().shutdown();
            this.factory.client().dispatcher().executorService().awaitTermination(5L, TimeUnit.MINUTES);
            this.factory.client().connectionPool().evictAll();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

