/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.http;

import com.cloudant.http.HttpConnectionInterceptorContext;
import com.cloudant.http.HttpConnectionRequestInterceptor;
import com.cloudant.http.HttpConnectionResponseInterceptor;
import com.cloudant.http.interceptors.BasicAuthInterceptor;
import com.cloudant.http.internal.DefaultHttpUrlConnectionFactory;
import com.cloudant.http.internal.Utils;
import com.cloudant.http.internal.interceptors.HttpConnectionInterceptorException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;

public class HttpConnection {
    private static final Logger logger = Logger.getLogger(HttpConnection.class.getCanonicalName());
    private final String requestMethod;
    public final URL url;
    private final String contentType;
    private HttpConnectionInterceptorContext currentContext = null;
    private HttpURLConnection connection;
    private InputStreamGenerator input;
    private long inputLength;
    public final HashMap<String, String> requestProperties;
    public final List<HttpConnectionRequestInterceptor> requestInterceptors;
    public final List<HttpConnectionResponseInterceptor> responseInterceptors;
    public HttpUrlConnectionFactory connectionFactory = new DefaultHttpUrlConnectionFactory();
    private int numberOfRetries = 10;
    private boolean requestIsLoggable = true;
    private String logIdentifier = null;

    public HttpConnection(String requestMethod, URL url, String contentType) {
        this.requestMethod = requestMethod;
        this.url = url;
        this.contentType = contentType;
        this.requestProperties = new HashMap();
        this.requestInterceptors = new LinkedList<HttpConnectionRequestInterceptor>();
        this.responseInterceptors = new LinkedList<HttpConnectionResponseInterceptor>();
        if (logger.isLoggable(Level.FINE)) {
            LogManager m = LogManager.getLogManager();
            String httpMethodFilter = m.getProperty("com.cloudant.http.filter.method");
            String urlFilter = m.getProperty("com.cloudant.http.filter.url");
            if (httpMethodFilter != null) {
                List<String> methods = Arrays.asList(httpMethodFilter.split(","));
                boolean bl = this.requestIsLoggable = this.requestIsLoggable && methods.contains(requestMethod);
            }
            if (urlFilter != null) {
                this.requestIsLoggable = this.requestIsLoggable && url.toString().matches(urlFilter);
            }
        }
    }

    public HttpConnection setNumberOfRetries(int numberOfRetries) {
        this.numberOfRetries = numberOfRetries;
        return this;
    }

    public int getNumberOfRetriesRemaining() {
        return this.numberOfRetries;
    }

    public HttpConnection setRequestBody(String input) {
        try {
            byte[] inputBytes = input.getBytes("UTF-8");
            return this.setRequestBody(inputBytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public HttpConnection setRequestBody(byte[] input) {
        return this.setRequestBody(new ByteArrayInputStream(input), (long)input.length);
    }

    public HttpConnection setRequestBody(InputStream input) {
        return this.setRequestBody(input, -1L);
    }

    public HttpConnection setRequestBody(InputStream input, long inputLength) {
        try {
            return this.setRequestBody(new InputStreamWrappingGenerator(input, inputLength), inputLength);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error copying input stream for request body", e);
            throw new RuntimeException(e);
        }
    }

    public HttpConnection setRequestBody(InputStreamGenerator input) {
        return this.setRequestBody(input, -1L);
    }

    public HttpConnection setRequestBody(InputStreamGenerator input, long inputLength) {
        this.input = input;
        this.inputLength = inputLength;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpConnection execute() throws IOException {
        boolean retry = true;
        while (retry && this.numberOfRetries-- > 0) {
            this.connection = this.connectionFactory.openConnection(this.url);
            if (this.url.getUserInfo() != null) {
                this.requestInterceptors.add(0, new BasicAuthInterceptor(this.url.getUserInfo()));
            }
            this.connection.setDoInput(true);
            this.connection.setRequestMethod(this.requestMethod);
            if (this.contentType != null) {
                this.connection.setRequestProperty("Content-type", this.contentType);
            }
            if (this.input != null) {
                this.connection.setDoOutput(true);
                if (this.inputLength != -1L) {
                    this.connection.setFixedLengthStreamingMode((int)this.inputLength);
                } else {
                    this.connection.setChunkedStreamingMode(0);
                }
            }
            this.currentContext = this.currentContext == null ? new HttpConnectionInterceptorContext(this) : new HttpConnectionInterceptorContext(this, this.currentContext.interceptorStates);
            for (HttpConnectionRequestInterceptor httpConnectionRequestInterceptor : this.requestInterceptors) {
                try {
                    this.currentContext = httpConnectionRequestInterceptor.interceptRequest(this.currentContext);
                }
                catch (HttpConnectionInterceptorException e) {
                    throw this.convertAndThrowInterceptorException(e);
                }
            }
            for (Map.Entry entry : this.requestProperties.entrySet()) {
                this.connection.setRequestProperty((String)entry.getKey(), (String)entry.getValue());
            }
            if (this.requestIsLoggable && logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("%s request%s", this.getLogRequestIdentifier(), this.connection.usingProxy() ? " via proxy" : ""));
            }
            if (this.requestIsLoggable && logger.isLoggable(Level.FINER)) {
                logger.finer(String.format("%s request headers %s", this.getLogRequestIdentifier(), this.connection.getRequestProperties()));
            }
            if (this.input != null) {
                InputStream is = this.input.getInputStream();
                OutputStream outputStream = this.connection.getOutputStream();
                try {
                    IOUtils.copyLarge((InputStream)is, (OutputStream)outputStream, (byte[])new byte[16384]);
                    outputStream.flush();
                }
                finally {
                    Utils.close(is);
                    Utils.close(outputStream);
                }
            }
            if (this.requestIsLoggable && logger.isLoggable(Level.FINE)) {
                logger.fine(String.format("%s response %s %s", this.getLogRequestIdentifier(), this.connection.getResponseCode(), this.connection.getResponseMessage()));
            }
            if (this.requestIsLoggable && logger.isLoggable(Level.FINER)) {
                logger.finer(String.format("%s response headers %s", this.getLogRequestIdentifier(), this.connection.getHeaderFields()));
            }
            for (HttpConnectionResponseInterceptor httpConnectionResponseInterceptor : this.responseInterceptors) {
                try {
                    this.currentContext = httpConnectionResponseInterceptor.interceptResponse(this.currentContext);
                }
                catch (HttpConnectionInterceptorException e) {
                    throw this.convertAndThrowInterceptorException(e);
                }
            }
            retry = this.currentContext.replayRequest;
            if (retry && this.numberOfRetries > 0) {
                Utils.consumeAndCloseStream(this.connection.getErrorStream());
            }
            if (this.numberOfRetries != 0) continue;
            logger.info("Maximum number of retries reached");
        }
        return this;
    }

    private HttpConnectionInterceptorException convertAndThrowInterceptorException(HttpConnectionInterceptorException e) throws IOException {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        return e;
    }

    public String responseAsString() throws IOException {
        return IOUtils.toString((byte[])this.responseAsBytes(), (String)"UTF-8");
    }

    public byte[] responseAsBytes() throws IOException {
        InputStream is = this.responseAsInputStream();
        try {
            byte[] byArray = IOUtils.toByteArray((InputStream)is);
            return byArray;
        }
        finally {
            Utils.close(is);
            this.disconnect();
        }
    }

    public InputStream responseAsInputStream() throws IOException {
        if (this.connection == null) {
            throw new IOException("Attempted to read response from server before calling execute()");
        }
        InputStream is = this.connection.getInputStream();
        return is;
    }

    public HttpURLConnection getConnection() {
        return this.connection;
    }

    public void disconnect() {
        this.connection.disconnect();
    }

    private String getLogRequestIdentifier() {
        if (this.logIdentifier == null) {
            this.logIdentifier = String.format("%s-%s %s %s", Integer.toHexString(this.hashCode()), this.numberOfRetries, this.connection.getRequestMethod(), this.connection.getURL());
        }
        return this.logIdentifier;
    }

    private static final class InputStreamWrappingGenerator
    implements InputStreamGenerator {
        private final InputStream inputStream;

        InputStreamWrappingGenerator(InputStream inputStream, long size) throws IOException {
            if (!inputStream.markSupported()) {
                byte[] inputBytes = size == -1L ? IOUtils.toByteArray((InputStream)inputStream) : IOUtils.toByteArray((InputStream)inputStream, (long)size);
                this.inputStream = new ByteArrayInputStream(inputBytes);
            } else {
                this.inputStream = inputStream;
            }
            this.inputStream.mark(Integer.MAX_VALUE);
        }

        @Override
        public InputStream getInputStream() throws IOException {
            this.inputStream.reset();
            return this.inputStream;
        }
    }

    public static interface InputStreamGenerator {
        public InputStream getInputStream() throws IOException;
    }

    public static interface HttpUrlConnectionFactory {
        public HttpURLConnection openConnection(URL var1) throws IOException;

        public void setProxy(URL var1);

        public void setProxyAuthentication(PasswordAuthentication var1);

        public void shutdown();
    }
}

