/*
 * Decompiled with CFR 0.152.
 */
package com.cloudant.client.api;

import com.cloudant.client.api.Database;
import com.cloudant.client.api.Replication;
import com.cloudant.client.api.Replicator;
import com.cloudant.client.api.model.ApiKey;
import com.cloudant.client.api.model.Membership;
import com.cloudant.client.api.model.Task;
import com.cloudant.client.internal.URIBase;
import com.cloudant.client.internal.util.DeserializationTypes;
import com.cloudant.client.org.lightcouch.CouchDbClient;
import com.cloudant.client.org.lightcouch.CouchDbProperties;
import com.cloudant.client.org.lightcouch.internal.CouchDbUtil;
import com.cloudant.http.HttpConnection;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.InputStream;
import java.net.URI;
import java.util.List;

public class CloudantClient {
    CouchDbClient couchDbClient;

    CloudantClient(CouchDbProperties props, GsonBuilder gsonBuilder) {
        this.couchDbClient = new CouchDbClient(props);
        this.couchDbClient.setGsonBuilder(gsonBuilder);
    }

    public ApiKey generateApiKey() {
        URI uri = ((URIBase)((URIBase)((URIBase)new URIBase(this.getBaseUri()).path("_api")).path("v2")).path("api_keys")).build();
        InputStream response = this.couchDbClient.post(uri, null);
        return CouchDbUtil.getResponse(response, ApiKey.class, this.getGson());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Task> getActiveTasks() {
        List<Task> list;
        InputStream response = null;
        URI uri = ((URIBase)new URIBase(this.getBaseUri()).path("_active_tasks")).build();
        try {
            response = this.couchDbClient.get(uri);
            list = CouchDbUtil.getResponseList(response, this.couchDbClient.getGson(), DeserializationTypes.TASKS);
        }
        catch (Throwable throwable) {
            CouchDbUtil.close(response);
            throw throwable;
        }
        CouchDbUtil.close(response);
        return list;
    }

    public Membership getMembership() {
        URI uri = ((URIBase)new URIBase(this.getBaseUri()).path("_membership")).build();
        Membership membership = this.couchDbClient.get(uri, Membership.class);
        return membership;
    }

    public Database database(String name, boolean create) {
        return new Database(this, this.couchDbClient.database(name, create));
    }

    public void deleteDB(String dbName) {
        this.couchDbClient.deleteDB(dbName);
    }

    public void createDB(String dbName) {
        this.couchDbClient.createDB(dbName);
    }

    public URI getBaseUri() {
        return this.couchDbClient.getBaseUri();
    }

    public List<String> getAllDbs() {
        return this.couchDbClient.getAllDbs();
    }

    public String serverVersion() {
        return this.couchDbClient.serverVersion();
    }

    public Replication replication() {
        com.cloudant.client.org.lightcouch.Replication couchDbReplication = this.couchDbClient.replication();
        Replication replication = new Replication(couchDbReplication);
        return replication;
    }

    public Replicator replicator() {
        com.cloudant.client.org.lightcouch.Replicator couchDbReplicator = this.couchDbClient.replicator();
        Replicator replicator = new Replicator(couchDbReplicator);
        return replicator;
    }

    public HttpConnection executeRequest(HttpConnection request) {
        return this.couchDbClient.execute(request);
    }

    public void shutdown() {
        this.couchDbClient.shutdown();
    }

    public List<String> uuids(long count) {
        return this.couchDbClient.uuids(count);
    }

    public Gson getGson() {
        return this.couchDbClient.getGson();
    }
}

