/*
 * Copyright (c) 2015 IBM Corp. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the
 * License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package com.cloudant.client.api.views;

import java.io.IOException;

/**
 * The AllDocsRequest is used for getting an AllDocsResponse
 */
public interface AllDocsRequest {

    /**
     * Performs the request and returns the response.
     * <P>
     * Example usage:
     * </P>
     * <pre>
     * {@code
     * AllDocsResponse response = db.getAllDocsRequestBuilder()
     *                              .build()
     *                              .getResponse();
     * }
     * </pre>
     *
     * @return the response object
     * @throws IOException if there is an error communicating with the server
     * @since 2.0.0
     */
    AllDocsResponse getResponse() throws IOException;
}
