/*
 * Decompiled with CFR 0.152.
 */
package jvm_alloc_rate_meter;

import com.sun.management.ThreadMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.math.BigInteger;
import java.util.List;
import java.util.function.LongConsumer;

public class MeterThread
extends Thread {
    private final MemoryMXBean memoryBean = ManagementFactory.getMemoryMXBean();
    private final ThreadMXBean threadBean = (ThreadMXBean)ManagementFactory.getThreadMXBean();
    private final List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
    private final LongConsumer callback;
    private final int intervalMs;
    private volatile boolean doRun = true;

    public MeterThread(LongConsumer longConsumer) {
        this(longConsumer, 1000);
    }

    public MeterThread(LongConsumer longConsumer, int n) {
        super("jvm-alloc-rate-meter-thread");
        this.callback = longConsumer;
        this.intervalMs = n;
        this.setDaemon(true);
    }

    @Override
    public void run() {
        long l = 0L;
        long l2 = -1L;
        long l3 = -1L;
        BigInteger bigInteger = BigInteger.valueOf(-1L);
        try {
            while (this.doRun) {
                long l4 = System.currentTimeMillis();
                double d = 1000.0 / (double)(l4 - l);
                long l5 = this.usedHeap();
                long l6 = this.gcCounts();
                long l7 = l5 - l2;
                BigInteger bigInteger2 = this.allocatedByAllThreads();
                BigInteger bigInteger3 = bigInteger2.subtract(bigInteger);
                if (l != 0L) {
                    long l8;
                    if (l6 == l3 && l7 >= 0L) {
                        l8 = Math.round((double)l7 * d);
                        this.callback.accept(l8);
                    } else if (bigInteger2.compareTo(BigInteger.ZERO) >= 0 && bigInteger.compareTo(BigInteger.ZERO) >= 0 && bigInteger3.compareTo(BigInteger.ZERO) >= 0) {
                        l8 = Math.round((double)bigInteger3.longValue() * d);
                        this.callback.accept(l8);
                    }
                }
                Thread.sleep(this.intervalMs);
                l = l4;
                l2 = l5;
                l3 = l6;
                bigInteger = bigInteger2;
            }
        }
        catch (InterruptedException interruptedException) {
            System.err.println("MeterThread terminating...");
        }
    }

    public void terminate() {
        this.doRun = false;
    }

    private long usedHeap() {
        return this.memoryBean.getHeapMemoryUsage().getUsed();
    }

    private long gcCounts() {
        long l = 0L;
        for (GarbageCollectorMXBean garbageCollectorMXBean : this.gcBeans) {
            l += garbageCollectorMXBean.getCollectionCount();
        }
        return l;
    }

    private BigInteger allocatedByAllThreads() {
        long[] lArray = this.threadBean.getAllThreadIds();
        long[] lArray2 = this.threadBean.getThreadAllocatedBytes(lArray);
        BigInteger bigInteger = BigInteger.ZERO;
        for (long l : lArray2) {
            bigInteger = bigInteger.add(BigInteger.valueOf(l));
        }
        return bigInteger;
    }
}

