/*
 * Decompiled with CFR 0.152.
 */
package com.clock.scratch;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Xfermode;
import android.graphics.drawable.BitmapDrawable;
import android.os.AsyncTask;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import com.clock.scratch.R;

public class ScratchView
extends View {
    private static final String TAG = ScratchView.class.getSimpleName();
    private static final float DEFAULT_ERASER_SIZE = 60.0f;
    private static final int DEFAULT_MASKER_COLOR = -3355444;
    private static final int DEFAULT_PERCENT = 70;
    private static final int MAX_PERCENT = 100;
    private Paint mMaskPaint;
    private Bitmap mMaskBitmap;
    private Canvas mMaskCanvas;
    private Paint mBitmapPaint;
    private BitmapDrawable mWatermark;
    private Paint mErasePaint;
    private Path mErasePath;
    private float mStartX;
    private float mStartY;
    private int mTouchSlop;
    private boolean mIsCompleted = false;
    private int mMaxPercent = 70;
    private int mPercent = 0;
    private int[] mPixels;
    private EraseStatusListener mEraseStatusListener;

    public ScratchView(Context context) {
        super(context);
        TypedArray typedArray = context.obtainStyledAttributes(R.styleable.ScratchView);
        this.init(typedArray);
    }

    public ScratchView(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ScratchView);
        this.init(typedArray);
    }

    public ScratchView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ScratchView, defStyleAttr, 0);
        this.init(typedArray);
    }

    @TargetApi(value=21)
    public ScratchView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.ScratchView, defStyleAttr, defStyleRes);
        this.init(typedArray);
    }

    private void init(TypedArray typedArray) {
        int maskColor = typedArray.getColor(R.styleable.ScratchView_maskColor, -3355444);
        int watermarkResId = typedArray.getResourceId(R.styleable.ScratchView_watermark, -1);
        float eraseSize = typedArray.getFloat(R.styleable.ScratchView_eraseSize, 60.0f);
        this.mMaxPercent = typedArray.getInt(R.styleable.ScratchView_maxPercent, 70);
        typedArray.recycle();
        this.mMaskPaint = new Paint();
        this.mMaskPaint.setAntiAlias(true);
        this.mMaskPaint.setDither(true);
        this.setMaskColor(maskColor);
        this.mBitmapPaint = new Paint();
        this.mBitmapPaint.setAntiAlias(true);
        this.mBitmapPaint.setDither(true);
        this.setWatermark(watermarkResId);
        this.mErasePaint = new Paint();
        this.mErasePaint.setAntiAlias(true);
        this.mErasePaint.setDither(true);
        this.mErasePaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.CLEAR));
        this.mErasePaint.setStyle(Paint.Style.STROKE);
        this.mErasePaint.setStrokeCap(Paint.Cap.ROUND);
        this.setEraserSize(eraseSize);
        this.mErasePath = new Path();
        ViewConfiguration viewConfiguration = ViewConfiguration.get((Context)this.getContext());
        this.mTouchSlop = viewConfiguration.getScaledTouchSlop();
    }

    public void setEraserSize(float eraserSize) {
        this.mErasePaint.setStrokeWidth(eraserSize);
    }

    public void setMaskColor(int color) {
        this.mMaskPaint.setColor(color);
    }

    public void setMaxPercent(int max) {
        if (max > 100 || max <= 0) {
            return;
        }
        this.mMaxPercent = max;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int measuredWidth = this.measureSize(widthMeasureSpec);
        int measuredHeight = this.measureSize(heightMeasureSpec);
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        canvas.drawBitmap(this.mMaskBitmap, 0.0f, 0.0f, this.mBitmapPaint);
    }

    public boolean onTouchEvent(MotionEvent event) {
        int action = event.getAction();
        switch (action) {
            case 0: {
                this.startErase(event.getX(), event.getY());
                this.invalidate();
                return true;
            }
            case 2: {
                this.erase(event.getX(), event.getY());
                this.invalidate();
                return true;
            }
            case 1: {
                this.stopErase();
                this.invalidate();
                return true;
            }
        }
        return super.onTouchEvent(event);
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        this.createMasker(w, h);
    }

    private void createMasker(int width, int height) {
        this.mMaskBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mMaskCanvas = new Canvas(this.mMaskBitmap);
        Rect rect = new Rect(0, 0, width, height);
        this.mMaskCanvas.drawRect(rect, this.mMaskPaint);
        if (this.mWatermark != null) {
            Rect bounds = new Rect(rect);
            this.mWatermark.setBounds(bounds);
            this.mWatermark.draw(this.mMaskCanvas);
        }
        this.mPixels = new int[width * height];
    }

    private int measureSize(int measureSpec) {
        int size = 0;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        if (specMode == 0x40000000) {
            size = specSize;
        } else if (specMode == Integer.MIN_VALUE) {
            size = Math.min(size, specSize);
        }
        return size;
    }

    private void startErase(float x, float y) {
        this.mErasePath.reset();
        this.mErasePath.moveTo(x, y);
        this.mStartX = x;
        this.mStartY = y;
    }

    private void erase(float x, float y) {
        int dx = (int)Math.abs(x - this.mStartX);
        int dy = (int)Math.abs(y - this.mStartY);
        if (dx >= this.mTouchSlop || dy >= this.mTouchSlop) {
            this.mStartX = x;
            this.mStartY = y;
            this.mErasePath.lineTo(x, y);
            this.mMaskCanvas.drawPath(this.mErasePath, this.mErasePaint);
            this.onErase();
            this.mErasePath.reset();
            this.mErasePath.moveTo(this.mStartX, this.mStartY);
        }
    }

    private void onErase() {
        int width = this.getWidth();
        int height = this.getHeight();
        new AsyncTask<Integer, Integer, Boolean>(){

            protected Boolean doInBackground(Integer ... params) {
                int width = params[0];
                int height = params[1];
                ScratchView.this.mMaskBitmap.getPixels(ScratchView.this.mPixels, 0, width, 0, 0, width, height);
                float erasePixelCount = 0.0f;
                float totalPixelCount = width * height;
                int pos = 0;
                while ((float)pos < totalPixelCount) {
                    if (ScratchView.this.mPixels[pos] == 0) {
                        erasePixelCount += 1.0f;
                    }
                    ++pos;
                }
                int percent = 0;
                if (erasePixelCount >= 0.0f && totalPixelCount > 0.0f) {
                    percent = Math.round(erasePixelCount * 100.0f / totalPixelCount);
                    this.publishProgress(new Integer[]{percent});
                }
                return percent >= ScratchView.this.mMaxPercent;
            }

            protected void onProgressUpdate(Integer ... values) {
                super.onProgressUpdate((Object[])values);
                ScratchView.this.mPercent = values[0];
                ScratchView.this.onPercentUpdate();
            }

            protected void onPostExecute(Boolean result) {
                super.onPostExecute((Object)result);
                if (result.booleanValue() && !ScratchView.this.mIsCompleted) {
                    ScratchView.this.mIsCompleted = true;
                    if (ScratchView.this.mEraseStatusListener != null) {
                        ScratchView.this.mEraseStatusListener.onCompleted(ScratchView.this);
                    }
                }
            }
        }.execute((Object[])new Integer[]{width, height});
    }

    private void stopErase() {
        this.mStartX = 0.0f;
        this.mStartY = 0.0f;
        this.mErasePath.reset();
    }

    private void onPercentUpdate() {
        if (this.mEraseStatusListener != null) {
            this.mEraseStatusListener.onProgress(this.mPercent);
        }
    }

    public void setEraseStatusListener(EraseStatusListener listener) {
        this.mEraseStatusListener = listener;
    }

    public void setWatermark(int resId) {
        if (resId == -1) {
            this.mWatermark = null;
        } else {
            Bitmap bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)resId);
            this.mWatermark = new BitmapDrawable(bitmap);
            this.mWatermark.setTileModeXY(Shader.TileMode.REPEAT, Shader.TileMode.REPEAT);
        }
    }

    public void reset() {
        this.mIsCompleted = false;
        int width = this.getWidth();
        int height = this.getHeight();
        this.createMasker(width, height);
        this.invalidate();
        this.onErase();
    }

    public void clear() {
        int width = this.getWidth();
        int height = this.getHeight();
        this.mMaskBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mMaskCanvas = new Canvas(this.mMaskBitmap);
        Rect rect = new Rect(0, 0, width, height);
        this.mMaskCanvas.drawRect(rect, this.mErasePaint);
        this.invalidate();
        this.onErase();
    }

    public static interface EraseStatusListener {
        public void onProgress(int var1);

        public void onCompleted(View var1);
    }
}

