/*
 * Decompiled with CFR 0.152.
 */
package com.clj.fastble.scan;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothAdapter;
import android.os.Handler;
import android.os.Looper;
import com.clj.fastble.BleManager;
import com.clj.fastble.callback.BleGattCallback;
import com.clj.fastble.callback.BleScanAndConnectCallback;
import com.clj.fastble.callback.BleScanCallback;
import com.clj.fastble.callback.BleScanPresenterImp;
import com.clj.fastble.data.BleDevice;
import com.clj.fastble.data.BleScanState;
import com.clj.fastble.scan.BleScanPresenter;
import com.clj.fastble.utils.BleLog;
import java.util.List;
import java.util.UUID;

@TargetApi(value=18)
public class BleScanner {
    private BleScanState mBleScanState = BleScanState.STATE_IDLE;
    private BleScanPresenter mBleScanPresenter = new BleScanPresenter(){

        @Override
        public void onScanStarted(boolean success) {
            BleScanPresenterImp callback = BleScanner.this.mBleScanPresenter.getBleScanPresenterImp();
            if (callback != null) {
                callback.onScanStarted(success);
            }
        }

        @Override
        public void onLeScan(BleDevice bleDevice) {
            if (BleScanner.this.mBleScanPresenter.ismNeedConnect()) {
                BleScanAndConnectCallback callback = (BleScanAndConnectCallback)BleScanner.this.mBleScanPresenter.getBleScanPresenterImp();
                if (callback != null) {
                    callback.onLeScan(bleDevice);
                }
            } else {
                BleScanCallback callback = (BleScanCallback)BleScanner.this.mBleScanPresenter.getBleScanPresenterImp();
                if (callback != null) {
                    callback.onLeScan(bleDevice);
                }
            }
        }

        @Override
        public void onScanning(BleDevice result) {
            BleScanPresenterImp callback = BleScanner.this.mBleScanPresenter.getBleScanPresenterImp();
            if (callback != null) {
                callback.onScanning(result);
            }
        }

        @Override
        public void onScanFinished(List<BleDevice> bleDeviceList) {
            if (BleScanner.this.mBleScanPresenter.ismNeedConnect()) {
                final BleScanAndConnectCallback callback = (BleScanAndConnectCallback)BleScanner.this.mBleScanPresenter.getBleScanPresenterImp();
                if (bleDeviceList == null || bleDeviceList.size() < 1) {
                    if (callback != null) {
                        callback.onScanFinished(null);
                    }
                } else {
                    if (callback != null) {
                        callback.onScanFinished(bleDeviceList.get(0));
                    }
                    final List<BleDevice> list = bleDeviceList;
                    new Handler(Looper.getMainLooper()).postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            BleManager.getInstance().connect((BleDevice)list.get(0), (BleGattCallback)callback);
                        }
                    }, 100L);
                }
            } else {
                BleScanCallback callback = (BleScanCallback)BleScanner.this.mBleScanPresenter.getBleScanPresenterImp();
                if (callback != null) {
                    callback.onScanFinished(bleDeviceList);
                }
            }
        }
    };

    public static BleScanner getInstance() {
        return BleScannerHolder.sBleScanner;
    }

    public void scan(UUID[] serviceUuids, String[] names, String mac, boolean fuzzy, long timeOut, BleScanCallback callback) {
        this.startLeScan(serviceUuids, names, mac, fuzzy, false, timeOut, callback);
    }

    public void scanAndConnect(UUID[] serviceUuids, String[] names, String mac, boolean fuzzy, long timeOut, BleScanAndConnectCallback callback) {
        this.startLeScan(serviceUuids, names, mac, fuzzy, true, timeOut, callback);
    }

    private synchronized void startLeScan(UUID[] serviceUuids, String[] names, String mac, boolean fuzzy, boolean needConnect, long timeOut, BleScanPresenterImp imp) {
        if (this.mBleScanState != BleScanState.STATE_IDLE) {
            BleLog.w("scan action already exists, complete the previous scan action first");
            if (imp != null) {
                imp.onScanStarted(false);
            }
            return;
        }
        this.mBleScanPresenter.prepare(names, mac, fuzzy, needConnect, timeOut, imp);
        boolean success = BleManager.getInstance().getBluetoothAdapter().startLeScan(serviceUuids, (BluetoothAdapter.LeScanCallback)this.mBleScanPresenter);
        this.mBleScanState = success ? BleScanState.STATE_SCANNING : BleScanState.STATE_IDLE;
        this.mBleScanPresenter.notifyScanStarted(success);
    }

    public synchronized void stopLeScan() {
        BleManager.getInstance().getBluetoothAdapter().stopLeScan((BluetoothAdapter.LeScanCallback)this.mBleScanPresenter);
        this.mBleScanState = BleScanState.STATE_IDLE;
        this.mBleScanPresenter.notifyScanStopped();
    }

    public BleScanState getScanState() {
        return this.mBleScanState;
    }

    private static class BleScannerHolder {
        private static final BleScanner sBleScanner = new BleScanner();

        private BleScannerHolder() {
        }
    }
}

